/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import lambdify.mojo.AWSMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="s3-deploy", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class S3UploaderMojo
extends AWSMojo {
    @Parameter(defaultValue="${project}", required=true)
    MavenProject project;
    @Parameter(defaultValue="true", required=true)
    Boolean enabled;
    @Parameter(defaultValue="us-east-1", required=true)
    String regionName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.zip", required=true)
    String zipFileName;
    @Parameter(defaultValue="${project.groupId}-${project.artifactId}-${project.version}.zip", required=true)
    String s3Key;
    @Parameter(required=true, defaultValue="UNDEFINED-S3-BUCKET")
    String s3Bucket;

    @Override
    protected void run() throws Exception {
        File file = new File(this.zipFileName);
        if (!file.exists()) {
            throw new FileNotFoundException(this.zipFileName);
        }
        this.uploadPackage(file);
    }

    private void uploadPackage(File file) {
        this.getLog().info((CharSequence)("Deploying package on AWS S3: " + this.s3Bucket + "/" + this.s3Key));
        AmazonS3 amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)this.credentials)).withRegion(Regions.fromName((String)this.regionName))).build();
        amazonS3.putObject(this.s3Bucket, this.s3Key, file);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getRegionName() {
        return this.regionName;
    }
}

