/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;

public class ZipFileReader
implements AutoCloseable {
    static final String MESSAGE_CANT_OPEN_ZIP = "Can't open zip file";
    final ZipFile zip;

    public ZipFileReader(String string) throws MojoExecutionException {
        try {
            this.zip = new ZipFile(string);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(MESSAGE_CANT_OPEN_ZIP, (Exception)iOException);
        }
    }

    public void read(BiConsumer<String, InputStream> biConsumer) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            InputStream inputStream = this.zip.getInputStream(zipEntry);
            biConsumer.accept(zipEntry.getName(), inputStream);
        }
    }

    @Override
    public void close() throws MojoExecutionException {
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(MESSAGE_CANT_OPEN_ZIP, (Exception)iOException);
        }
    }
}

