/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;

public class ZipFileWriter
implements AutoCloseable {
    static final String MESSAGE_CANT_CREATE_ZIP = "Can't create zip file";
    static final String MESSAGE_CANT_ADD_TO_ZIP = "Can't add file to zip";
    final List<String> prefixesToStripOutFromName = new ArrayList<String>();
    final ZipOutputStream output;
    final String fileName;
    final String rootDirectory;

    public ZipFileWriter(String string) throws MojoExecutionException {
        this(string, "");
    }

    public ZipFileWriter(String string, String string2) throws MojoExecutionException {
        try {
            this.fileName = string;
            this.rootDirectory = string2;
            this.output = new ZipOutputStream(new FileOutputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MojoExecutionException(MESSAGE_CANT_CREATE_ZIP, (Exception)fileNotFoundException);
        }
    }

    public void add(String string) {
        this.add(string, null);
    }

    public void add(String string, InputStream inputStream) {
        try {
            String string2 = this.fixEntryName(string);
            if (string2.isEmpty()) {
                return;
            }
            this.output.putNextEntry(new ZipEntry(string2));
            if (inputStream != null) {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) >= 0) {
                    this.output.write(byArray, 0, n);
                }
                this.output.closeEntry();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(MESSAGE_CANT_ADD_TO_ZIP, iOException);
        }
    }

    String fixEntryName(String string) {
        for (String string2 : this.prefixesToStripOutFromName) {
            string = string.replaceFirst(string2, "");
        }
        String string3 = this.rootDirectory + "/" + string;
        return string3.replaceFirst("^/", "");
    }

    @Override
    public void close() throws MojoExecutionException {
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(MESSAGE_CANT_CREATE_ZIP, (Exception)iOException);
        }
    }

    public void stripPrefix(String ... stringArray) {
        for (String string : stringArray) {
            this.prefixesToStripOutFromName.add(string);
        }
    }

    public List<String> getPrefixesToStripOutFromName() {
        return this.prefixesToStripOutFromName;
    }

    public ZipOutputStream getOutput() {
        return this.output;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }
}

