/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import lambdify.mojo.ZipFileReader;
import lambdify.mojo.ZipFileWriter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ZipPackager
implements AutoCloseable {
    final ZipFileWriter zip;

    public ZipPackager(String string) throws MojoExecutionException {
        this.zip = new ZipFileWriter(string);
    }

    void copyDependenciesToZip(MavenProject mavenProject) throws MojoExecutionException {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            for (Artifact artifact : mavenProject.getArtifacts()) {
                String string = this.getArtifactAbsolutePath(artifact);
                if (hashSet.contains(string)) continue;
                this.copyDependencyToZip(artifact, string);
                hashSet.add(string);
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Can't copy dependencies to zip", (Exception)iOException);
        }
    }

    String getArtifactAbsolutePath(Artifact artifact) {
        return artifact.getFile().getAbsolutePath();
    }

    void copyDependencyToZip(Artifact artifact, String string) throws IOException {
        if (artifact.getScope().equals("provided")) {
            return;
        }
        String string2 = "lib/" + artifact.getArtifactId() + "." + artifact.getType();
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            this.zip.add(string2, fileInputStream);
        }
    }

    void copyFilesFromJarToZip(String string) throws MojoExecutionException {
        try (ZipFileReader zipFileReader = new ZipFileReader(string.replace("%20", " "));){
            zipFileReader.read(this.zip::add);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Can't read " + string, (Exception)iOException);
        }
    }

    @Override
    public void close() throws MojoExecutionException {
        this.zip.close();
    }
}

