/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.br;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class BretonTagger
extends BaseTagger {
    private static final Pattern patternSuffix = Pattern.compile("(?iu)(..+)-(ma\u00f1|se|hont)$");
    private final Locale conversionLocale = Locale.getDefault();

    public final String getFileName() {
        return "/br/breton.dict";
    }

    public String getManualAdditionsFileName() {
        return "/br/added.txt";
    }

    public BretonTagger() {
        this.setLocale(new Locale("br"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        Iterator<String> i$ = sentenceTokens.iterator();
        while (i$.hasNext()) {
            ArrayList<AnalyzedToken> l;
            String word;
            block4: {
                String probeWord = word = i$.next();
                while (true) {
                    List upperTaggerTokens;
                    l = new ArrayList<AnalyzedToken>();
                    String lowerWord = probeWord.toLowerCase(this.conversionLocale);
                    List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(probeWord));
                    List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                    boolean isLowercase = probeWord.equals(lowerWord);
                    this.addTokens(taggerTokens, l);
                    if (!isLowercase) {
                        this.addTokens(lowerTaggerTokens, l);
                    }
                    if (!lowerTaggerTokens.isEmpty() || !taggerTokens.isEmpty()) break block4;
                    if (isLowercase && !(upperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)probeWord)))).isEmpty()) {
                        this.addTokens(upperTaggerTokens, l);
                    }
                    if (!l.isEmpty()) break block4;
                    Matcher matcher = patternSuffix.matcher(probeWord);
                    if (!matcher.find()) break;
                    probeWord = matcher.group(1);
                }
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                l.add(at);
            }
        }
    }
}

