/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.br.MorfologikBretonSpellerRule;
import org.languagetool.rules.br.TopoReplaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.br.BretonTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.br.BretonWordTokenizer;

public class Breton
extends Language {
    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new BretonWordTokenizer();
    }

    public String getName() {
        return "Breton";
    }

    public String getShortCode() {
        return "br";
    }

    public String[] getCountries() {
        return new String[]{"FR"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new BretonTagger();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new XmlRuleDisambiguator((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.DOMINIQUE_PELLE, new Contributor("Fulup Jakez")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MorfologikBretonSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new TopoReplaceRule(messages)});
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

