/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.Tagger;

public class InsertCommaFilter
extends RuleFilter {
    private static final Tagger tagger = Languages.getLanguageForShortCode((String)"de").getTagger();

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String replacement : match.getSuggestedReplacements()) {
            String[] parts = replacement.split("\\s");
            if (parts.length == 2) {
                suggestions.add(parts[0] + ", " + parts[1]);
                continue;
            }
            if (parts.length != 3) continue;
            try {
                List tags1 = tagger.tag(Collections.singletonList(parts[0]));
                List tags2 = tagger.tag(Collections.singletonList(parts[1]));
                if (tags1.stream().anyMatch(k -> k.hasPosTagStartingWith("VER:")) && tags2.stream().anyMatch(k -> k.hasPosTagStartingWith("PRO:PER:"))) {
                    suggestions.add(parts[0] + ", " + parts[1] + " " + parts[2]);
                    continue;
                }
                if (!parts[0].matches("Sag|Sagt") || !parts[1].matches("mal") || !tagger.tag(Collections.singletonList(parts[2])).stream().anyMatch(k -> k.hasPosTagStartingWith("VER:"))) continue;
                suggestions.add(parts[0] + " " + parts[1] + ", " + parts[2]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ruleMatch.setSuggestedReplacements(suggestions);
        ruleMatch.setType(match.getType());
        return ruleMatch;
    }
}

