/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSetHelper;
import org.ldp4j.application.data.DataSetUtils;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.example.InMemoryContainerHandler;
import org.ldp4j.example.PersonHandler;

public class AbstractPersonContainerHandler
extends InMemoryContainerHandler {
    private PersonHandler handler;
    private AtomicInteger id = new AtomicInteger();

    protected AbstractPersonContainerHandler(String name) {
        super(name);
    }

    public final void setHandler(PersonHandler handler) {
        this.handler = handler;
    }

    public final ResourceSnapshot create(ContainerSnapshot container, DataSet representation, WriteSession session) {
        Name name = NamingScheme.getDefault().name((Number)this.id.incrementAndGet());
        DataSetHelper helper = DataSetUtils.newHelper((DataSet)representation);
        ManagedIndividual individual = (ManagedIndividual)helper.replace((Serializable)DataSetHelper.SELF, (Serializable)ManagedIndividualId.createId((Name)name, (String)"personTemplate"), ManagedIndividual.class);
        individual.addValue(URI.create("http://www.example.org/vocab#creationDate"), (Value)Literals.of((Date)new Date()).dateTime());
        try {
            this.handler.add(name, representation);
            ResourceSnapshot member = container.addMember(name);
            session.saveChanges();
            return member;
        }
        catch (Exception e) {
            this.handler.remove(name);
            throw new ApplicationRuntimeException("Could not create member", (Throwable)e);
        }
    }
}

