/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.SnapshotResolver;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.MyApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicResourceResolver
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyApplication.class);
    public static final URI SNAPSHOT_RESOLUTION = URI.create("http://www.ldp4j.org/ns#snapshotResolution");
    public static final URI SNAPSHOT_ENDPOINT = URI.create("http://www.ldp4j.org/ns#snapshotEndpoint");
    public static final URI CANONICAL_BASE = URI.create("http://www.ldp4j.org/fixture/ldp4j/api/");
    private DynamicResourceHandler handler;
    private Name<String> name;

    public DynamicResourceResolver(DynamicResourceHandler handler, Name<String> name) {
        this.handler = handler;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ApplicationContext ctx = ApplicationContext.getInstance();
        LOGGER.debug("Starting resolution process on {}...", (Object)new Date());
        try (WriteSession session = ctx.createSession();){
            ResourceSnapshot snapshot = session.find(ResourceSnapshot.class, this.name, DynamicResourceHandler.class);
            DataSet dataSet = this.handler.get(snapshot);
            Individual individual = dataSet.individualOfId((Serializable)ManagedIndividualId.createId((Name)snapshot.name(), (String)snapshot.templateId()));
            SnapshotResolver snapshotResolver = SnapshotResolver.builder().withReadSession((ReadSession)session).withCanonicalBase(CANONICAL_BASE).build();
            URI snapshotEndpoint = snapshotResolver.toURI(snapshot);
            individual.addValue(SNAPSHOT_ENDPOINT, (Value)Literals.newLiteral((Object)snapshotEndpoint));
            individual.addValue(SNAPSHOT_RESOLUTION, (Value)Literals.newLiteral((Object)this.roundtrip(snapshotResolver, snapshotEndpoint, snapshot)));
            this.handler.update(this.name, dataSet);
            session.modify(snapshot);
            session.saveChanges();
        }
        catch (Exception e) {
            LOGGER.error("Could not resolve resource", (Throwable)e);
        }
        finally {
            LOGGER.debug("Finalized resolution process");
        }
    }

    private String roundtrip(SnapshotResolver snapshotResolver, URI snapshotEndpoint, ResourceSnapshot original) {
        ResourceSnapshot resolved = snapshotResolver.fromURI(snapshotEndpoint);
        return resolved != null && resolved.name().equals(original.name()) && resolved.handlerClass() == original.handlerClass() ? "OK" : "KO";
    }
}

