/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.MyApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DynamicResourceUpdater
implements Runnable {
    static final URI REFRESHED_ON = URI.create("http://www.ldp4j.org/ns#refreshedOn");
    private static final Logger LOGGER = LoggerFactory.getLogger(MyApplication.class);
    private DynamicResourceHandler handler;
    private Name<String> name;

    public DynamicResourceUpdater(DynamicResourceHandler handler, Name<String> name) {
        this.handler = handler;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ApplicationContext ctx = ApplicationContext.getInstance();
        Date date = new Date();
        LOGGER.debug("Starting update process on {}...", (Object)date);
        try (WriteSession session = ctx.createSession();){
            ResourceSnapshot snapshot = session.find(ResourceSnapshot.class, this.name, DynamicResourceHandler.class);
            DataSet dataSet = this.handler.get(snapshot);
            Individual individual = dataSet.individualOfId((Serializable)ManagedIndividualId.createId(this.name, (String)"DynamicResourceHandler"));
            individual.addValue(REFRESHED_ON, (Value)Literals.of((Date)date).dateTime());
            this.handler.update(this.name, dataSet);
            session.modify(snapshot);
            session.saveChanges();
        }
        catch (Exception e) {
            LOGGER.error("Could not update resource", (Throwable)e);
        }
        finally {
            LOGGER.debug("Finalized update process");
        }
    }
}

