/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ldp4j.application.data.DataDSL;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.IndividualReferenceBuilder;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.Application;
import org.ldp4j.application.ext.ApplicationInitializationException;
import org.ldp4j.application.ext.ApplicationSetupException;
import org.ldp4j.application.ext.Configuration;
import org.ldp4j.application.ext.ResourceHandler;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.application.setup.Bootstrap;
import org.ldp4j.application.setup.Environment;
import org.ldp4j.example.BadDataResourceHandler;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.DynamicResourceResolver;
import org.ldp4j.example.DynamicResourceUpdater;
import org.ldp4j.example.PersonContainerHandler;
import org.ldp4j.example.PersonHandler;
import org.ldp4j.example.QueryableResourceHandler;
import org.ldp4j.example.RelativeContainerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyApplication
extends Application<Configuration> {
    private static final String PERSON_CONTAINER_NAME = "PersonContainer";
    private static final String PERSON_RESOURCE_NAME = "PersonResource";
    private static final String RELATIVE_CONTAINER_NAME = "RelativeContainer";
    private static final String QUERYABLE_RESOURCE_NAME = "QueryableResource";
    private static final String DYNAMIC_RESOURCE_NAME = "DynamicResource";
    private static final String BAD_DATA_RESOURCE_NAME = "BadDataResource";
    public static final String ROOT_PERSON_RESOURCE_PATH = "rootPersonResource/";
    public static final String ROOT_PERSON_CONTAINER_PATH = "rootPersonContainer/";
    public static final String ROOT_QUERYABLE_RESOURCE_PATH = "rootQueryableResource/";
    public static final String ROOT_DYNAMIC_RESOURCE_PATH = "rootDynamicResource/";
    public static final String ROOT_BAD_DATA_RESOURCE_PATH = "rootBadDataResource/";
    private static final Logger LOGGER = LoggerFactory.getLogger(MyApplication.class);
    private final Name<String> personResourceName = NamingScheme.getDefault().name((Serializable)((Object)"PersonResource"));
    private final Name<String> personContainerName = NamingScheme.getDefault().name((Serializable)((Object)"PersonContainer"));
    private final Name<String> relativeContainerResourceName = NamingScheme.getDefault().name((Serializable)((Object)"RelativeContainer"));
    private final Name<String> queryableResourceName = NamingScheme.getDefault().name((Serializable)((Object)"QueryableResource"));
    private final Name<String> dynamicResourceName = NamingScheme.getDefault().name((Serializable)((Object)"DynamicResource"));
    private final Name<String> badDataResourceName = NamingScheme.getDefault().name((Serializable)((Object)"BadDataResource"));
    private DynamicResourceHandler dynamicResourceHandler;
    private ScheduledExecutorService executorService;

    private DataSet getInitialData(String templateId, String name) {
        return DataDSL.dataSet().individual(IndividualReferenceBuilder.newReference().toManagedIndividual(templateId).named(name, new String[0])).hasProperty("http://www.ldp4j.org/vocabulary/example#creationDate").withValue((Object)new Date()).hasProperty("http://www.ldp4j.org/vocabulary/example#age").withValue((Object)34).hasLink("http://www.ldp4j.org/vocabulary/example#hasFather").toIndividual(IndividualReferenceBuilder.newReference().toLocalIndividual().named("Michel", new String[0])).hasLink("http://www.ldp4j.org/vocabulary/example#hasWife").referringTo(IndividualReferenceBuilder.newReference().toLocalIndividual().named("Consuelo", new String[0])).build();
    }

    protected final Name<String> personResourceName() {
        return this.personResourceName;
    }

    protected final Name<String> personContainerName() {
        return this.personContainerName;
    }

    protected final Name<String> relativeContainerResourceName() {
        return this.relativeContainerResourceName;
    }

    protected final Name<String> dynamicResourceName() {
        return this.dynamicResourceName;
    }

    protected final Name<String> badDataResourceName() {
        return this.badDataResourceName;
    }

    protected final DynamicResourceHandler dynamicResourceHandler() {
        return this.dynamicResourceHandler;
    }

    public void setup(Environment environment, Bootstrap<Configuration> bootstrap) throws ApplicationSetupException {
        LOGGER.info("Configuring application: {}, {}", (Object)environment, bootstrap);
        PersonHandler resourceHandler = new PersonHandler();
        PersonContainerHandler containerHandler = new PersonContainerHandler();
        RelativeContainerHandler relativesHandler = new RelativeContainerHandler();
        QueryableResourceHandler queryableHandler = new QueryableResourceHandler();
        this.dynamicResourceHandler = new DynamicResourceHandler();
        BadDataResourceHandler badDataHandler = new BadDataResourceHandler();
        containerHandler.setHandler(resourceHandler);
        relativesHandler.setHandler(resourceHandler);
        resourceHandler.add(this.personResourceName, this.getInitialData("personTemplate", PERSON_RESOURCE_NAME));
        containerHandler.add(this.personContainerName, this.getInitialData("personContainerTemplate", PERSON_CONTAINER_NAME));
        relativesHandler.add(this.relativeContainerResourceName, this.getInitialData("relativeContainerTemplate", RELATIVE_CONTAINER_NAME));
        queryableHandler.add(this.queryableResourceName, this.getInitialData("queryableResourceTemplate", QUERYABLE_RESOURCE_NAME));
        this.dynamicResourceHandler.add(this.dynamicResourceName, this.getInitialData("DynamicResourceHandler", DYNAMIC_RESOURCE_NAME));
        badDataHandler.add(this.badDataResourceName, badDataHandler.getRepresentation());
        bootstrap.addHandler((ResourceHandler)resourceHandler);
        bootstrap.addHandler((ResourceHandler)containerHandler);
        bootstrap.addHandler((ResourceHandler)relativesHandler);
        bootstrap.addHandler((ResourceHandler)queryableHandler);
        bootstrap.addHandler((ResourceHandler)this.dynamicResourceHandler);
        bootstrap.addHandler((ResourceHandler)badDataHandler);
        environment.publishResource(this.personResourceName, PersonHandler.class, ROOT_PERSON_RESOURCE_PATH);
        environment.publishResource(this.personContainerName, PersonContainerHandler.class, ROOT_PERSON_CONTAINER_PATH);
        environment.publishResource(this.queryableResourceName, QueryableResourceHandler.class, ROOT_QUERYABLE_RESOURCE_PATH);
        environment.publishResource(this.dynamicResourceName, DynamicResourceHandler.class, ROOT_DYNAMIC_RESOURCE_PATH);
        environment.publishResource(this.badDataResourceName, BadDataResourceHandler.class, ROOT_BAD_DATA_RESOURCE_PATH);
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("daemon-updater-thread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggedUncaughtExceptionHandler(LOGGER)).build());
        LOGGER.info("Configuration completed.");
    }

    public void initialize(WriteSession session) throws ApplicationInitializationException {
        LOGGER.info("Initializing application: {}", (Object)session);
        ResourceSnapshot person = session.find(ResourceSnapshot.class, this.personResourceName, PersonHandler.class);
        LOGGER.info("Root resource.......: " + person);
        LOGGER.info("Root basic container: " + session.find(ResourceSnapshot.class, this.personContainerName, PersonContainerHandler.class));
        ContainerSnapshot relativesContainer = (ContainerSnapshot)person.createAttachedResource(ContainerSnapshot.class, "personRelatives", this.relativeContainerResourceName, RelativeContainerHandler.class);
        LOGGER.info("Attached resource...: " + relativesContainer);
        try {
            session.saveChanges();
        }
        catch (WriteSessionException e) {
            throw new ApplicationInitializationException("Could not initialize application", (Throwable)e);
        }
        this.executorService.scheduleAtFixedRate(new DynamicResourceUpdater(this.dynamicResourceHandler, this.dynamicResourceName), 1L, 15L, TimeUnit.SECONDS);
        this.executorService.schedule(new DynamicResourceResolver(this.dynamicResourceHandler, this.dynamicResourceName), 3L, TimeUnit.SECONDS);
        LOGGER.info("Initialization completed.");
    }

    public void shutdown() {
        LOGGER.info("Shutting down application...");
        this.executorService.shutdown();
        boolean finished = this.executorService.isTerminated();
        while (!finished) {
            try {
                this.executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
                finished = this.executorService.isTerminated();
            }
            catch (InterruptedException e) {
                finished = true;
            }
        }
        LOGGER.info("Shutdown completed.");
    }

    static final class LoggedUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger logger;

        LoggedUncaughtExceptionHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.logger.error(String.format("Thread %s died", t.getName()), e);
        }
    }
}

