/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.example.BookContainerHandler;
import org.ldp4j.example.BookHandler;
import org.ldp4j.example.NameProvider;

@RunWith(value=JMockit.class)
public class BookContainerHandlerTest {
    @Mocked
    WriteSession session;
    @Mocked
    ContainerSnapshot snapshot;
    @Mocked
    ResourceSnapshot memberSnapshot;

    private Name<String> name(String string) {
        return NamingScheme.getDefault().name((Serializable)((Object)string));
    }

    @Test
    public void testGetHandler$failure() {
        BookContainerHandler containerHandler = new BookContainerHandler();
        try {
            containerHandler.bookHandler();
            Assert.fail((String)"Should fail if no book handler is available");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCreate$happyPath() throws Exception {
        BookContainerHandler containerHandler = new BookContainerHandler();
        BookHandler resourceHandler = new BookHandler();
        final Name<String> containerName = this.name("container");
        NameProvider provider = NameProvider.create(containerName);
        final Name<String> memberName = this.name("resource");
        provider.addMemberName(memberName);
        containerHandler.addNameProvider(provider.owner(), provider);
        containerHandler.setBookHandler(resourceHandler);
        DataSet data = DataSets.createDataSet(memberName);
        new Expectations(){
            {
                BookContainerHandlerTest.this.snapshot.name();
                this.result = containerName;
                BookContainerHandlerTest.this.memberSnapshot.name();
                this.result = memberName;
            }
        };
        containerHandler.create(this.snapshot, data, this.session);
        MatcherAssert.assertThat((Object)provider.pendingMemberNames(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new Name[]{memberName})));
        MatcherAssert.assertThat((Object)resourceHandler.get(this.memberSnapshot), (Matcher)Matchers.sameInstance((Object)data));
    }

    @Test
    public void testCreate$exceptionPath() throws Exception {
        BookContainerHandler containerHandler = new BookContainerHandler();
        BookHandler resourceHandler = new BookHandler();
        final Name<String> containerName = this.name("container");
        NameProvider provider = NameProvider.create(containerName);
        final Name<String> memberName = this.name("resource");
        provider.addMemberName(memberName);
        containerHandler.addNameProvider(provider.owner(), provider);
        containerHandler.setBookHandler(resourceHandler);
        DataSet data = DataSets.createDataSet(memberName);
        new Expectations(){
            {
                BookContainerHandlerTest.this.snapshot.name();
                this.result = containerName;
                BookContainerHandlerTest.this.memberSnapshot.name();
                this.result = memberName;
                BookContainerHandlerTest.this.session.saveChanges();
                this.result = new WriteSessionException("FAILURE");
            }
        };
        try {
            containerHandler.create(this.snapshot, data, this.session);
            Assert.fail((String)"Should not create if the session fails");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(WriteSessionException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
            MatcherAssert.assertThat((Object)provider.pendingMemberNames(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new Name[]{memberName})));
            try {
                resourceHandler.get(this.memberSnapshot);
                Assert.fail((String)"Resource should not be available in the resource handler");
            }
            catch (UnknownResourceException e1) {
                // empty catch block
            }
        }
    }
}

