/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.SessionTerminationException;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.DynamicResourceResolver;
import org.ldp4j.example.MockedRuntimeDelegate;
import org.ldp4j.example.PersonHandler;

@RunWith(value=JMockit.class)
public class DynamicResourceResolverTest {
    private static final URI ENDPOINT = DynamicResourceResolver.CANONICAL_BASE.resolve("path/");
    private static final Name<String> RID = NamingScheme.getDefault().name((Serializable)((Object)"resource"));
    private static MockedRuntimeDelegate DELEGATE;
    @Mocked
    ResourceSnapshotResolver resolver;

    @BeforeClass
    public static void setUpBefore() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new MockedRuntimeDelegate());
        ApplicationContext instance = ApplicationContext.getInstance();
        Deencapsulation.setField((Object)instance, (String)"delegate", (Object)RuntimeDelegate.getInstance());
        DELEGATE = (MockedRuntimeDelegate)((Object)Deencapsulation.getField((Object)instance, (String)"delegate"));
    }

    @Test
    public void testRun(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.workingSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "OK");
    }

    @Test
    public void testRun$roundtripFailure$noSnapshotFound(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.roundtripFailureSut(handler, session, snapshot, null);
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "KO");
    }

    @Test
    public void testRun$roundtripFailure$differentName(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot, final @Mocked ResourceSnapshot resolved) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.roundtripFailureSut(handler, session, snapshot, resolved);
        new Expectations(){
            {
                resolved.name();
                this.result = NamingScheme.getDefault().name((Serializable)((Object)"other"));
            }
        };
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "KO");
    }

    @Test
    public void testRun$roundtripFailure$differentHandler(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot, final @Mocked ResourceSnapshot resolved) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.roundtripFailureSut(handler, session, snapshot, resolved);
        new Expectations(){
            {
                resolved.name();
                this.result = RID;
                resolved.handlerClass();
                this.result = PersonHandler.class;
            }
        };
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "KO");
    }

    @Test
    public void testRun$failure$runtimeException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.runtimeFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false, false, null);
    }

    @Test
    public void testRun$failure$nullWriteSession(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.nullWriteSessionSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false, false, null);
    }

    @Test
    public void testRun$failure$writeSessionCreationException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.writeSessionCreationFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false, false, null);
    }

    @Test
    public void testRun$failure$writeSessionException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.writeSessionFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "OK");
    }

    @Test
    public void testRun$failure$writeSessionTerminationFailure(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.writeSessionTerminationSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "OK");
    }

    @Test
    public void testRun$failure$writeSessionAndTerminationFailure(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceResolver sut = this.writeSessionFailureWithTerminationFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true, true, "OK");
    }

    private void verifyResult(ResourceSnapshot snapshot, DynamicResourceHandler handler, boolean resolveToUri, boolean resolveRoundtrip, String roundtrip) throws UnknownResourceException {
        DataSet dataSet = handler.get(snapshot);
        Individual resource = dataSet.individualOfId((Serializable)ManagedIndividualId.createId(RID, (String)"DynamicResourceHandler"));
        MatcherAssert.assertThat((String)("Could " + (resolveToUri ? "not" : "") + " resolve uri"), (Object)resource.hasProperty(DynamicResourceResolver.SNAPSHOT_ENDPOINT), (Matcher)Matchers.equalTo((Object)resolveToUri));
        if (resolveToUri) {
            MatcherAssert.assertThat((String)"Invalid uri resolution", (Object)resource.property(DynamicResourceResolver.SNAPSHOT_ENDPOINT).hasLiteralValue(Literals.newLiteral((Object)ENDPOINT)), (Matcher)Matchers.equalTo((Object)resolveRoundtrip));
        }
        MatcherAssert.assertThat((String)("Could " + (resolveRoundtrip ? "not" : "") + " resolve roundtrip"), (Object)resource.hasProperty(DynamicResourceResolver.SNAPSHOT_RESOLUTION), (Matcher)Matchers.equalTo((Object)resolveRoundtrip));
        if (resolveRoundtrip) {
            MatcherAssert.assertThat((String)"Invalid roundtrip resolution", (Object)resource.property(DynamicResourceResolver.SNAPSHOT_RESOLUTION).hasLiteralValue(Literals.of((String)roundtrip)), (Matcher)Matchers.equalTo((Object)resolveRoundtrip));
        }
    }

    private DynamicResourceResolver workingSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        DELEGATE.setResolver(this.resolver);
        new Expectations(){
            {
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                snapshot.name();
                this.result = RID;
                snapshot.templateId();
                this.result = "DynamicResourceHandler";
                DynamicResourceResolverTest.this.resolver.resolve(snapshot);
                this.result = ENDPOINT;
                DynamicResourceResolverTest.this.resolver.resolve(ENDPOINT);
                this.result = snapshot;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver roundtripFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot, final ResourceSnapshot resolved) {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        DELEGATE.setResolver(this.resolver);
        new Expectations(){
            {
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                snapshot.name();
                this.result = RID;
                snapshot.templateId();
                this.result = "DynamicResourceHandler";
                DynamicResourceResolverTest.this.resolver.resolve(snapshot);
                this.result = ENDPOINT;
                DynamicResourceResolverTest.this.resolver.resolve(ENDPOINT);
                this.result = resolved;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver runtimeFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = new IllegalStateException("FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver nullWriteSessionSut(DynamicResourceHandler handler, WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        DELEGATE.setSession(null);
        DELEGATE.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver writeSessionCreationFailureSut(DynamicResourceHandler handler, WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(true);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver writeSessionFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        new Expectations(){
            {
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                snapshot.name();
                this.result = RID;
                snapshot.templateId();
                this.result = "DynamicResourceHandler";
                DynamicResourceResolverTest.this.resolver.resolve(snapshot);
                this.result = ENDPOINT;
                DynamicResourceResolverTest.this.resolver.resolve(ENDPOINT);
                this.result = snapshot;
                session.saveChanges();
                this.result = new WriteSessionException();
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver writeSessionFailureWithTerminationFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws Exception {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        new Expectations(){
            {
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                snapshot.name();
                this.result = RID;
                snapshot.templateId();
                this.result = "DynamicResourceHandler";
                DynamicResourceResolverTest.this.resolver.resolve(snapshot);
                this.result = ENDPOINT;
                DynamicResourceResolverTest.this.resolver.resolve(ENDPOINT);
                this.result = snapshot;
                session.saveChanges();
                this.result = new WriteSessionException("SAVE_FAILURE");
                session.close();
                this.result = new SessionTerminationException("CLOSE_FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver writeSessionTerminationSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws Exception {
        DELEGATE.setSession(session);
        DELEGATE.setFailure(false);
        new Expectations(){
            {
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                snapshot.name();
                this.result = RID;
                snapshot.templateId();
                this.result = "DynamicResourceHandler";
                DynamicResourceResolverTest.this.resolver.resolve(snapshot);
                this.result = ENDPOINT;
                DynamicResourceResolverTest.this.resolver.resolve(ENDPOINT);
                this.result = snapshot;
                session.close();
                this.result = new SessionTerminationException("FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceResolver createSut(DynamicResourceHandler handler) {
        DataSet dataSet = DataSets.createDataSet(RID);
        dataSet.individual((Serializable)ManagedIndividualId.createId(RID, (String)"DynamicResourceHandler"), ManagedIndividual.class);
        handler.add(RID, dataSet);
        return new DynamicResourceResolver(handler, RID);
    }
}

