/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.SessionTerminationException;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.DynamicResourceUpdater;
import org.ldp4j.example.MockedRuntimeDelegate;

@RunWith(value=JMockit.class)
public class DynamicResourceUpdaterTest {
    private static final Name<String> RID = NamingScheme.getDefault().name((Serializable)((Object)"resource"));
    private MockedRuntimeDelegate delegate;

    @Before
    public void setUp() {
        this.delegate = new MockedRuntimeDelegate();
        Deencapsulation.setField((Object)ApplicationContext.getInstance(), (String)"delegate", (Object)((Object)this.delegate));
    }

    @Test
    public void testRun(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.workingSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true);
    }

    @Test
    public void testRun$failure$runtimeException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.runtimeFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false);
    }

    @Test
    public void testRun$failure$nullWriteSession(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.nullWriteSessionSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false);
    }

    @Test
    public void testRun$failure$writeSessionCreationException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.writeSessionCreationFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, false);
    }

    @Test
    public void testRun$failure$writeSessionException(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.writeSessionFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true);
    }

    @Test
    public void testRun$failure$writeSessionTerminationFailure(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.writeSessionTerminationSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true);
    }

    @Test
    public void testRun$failure$writeSessionAndTerminationFailure(@Mocked WriteSession session, @Mocked ResourceSnapshot snapshot) throws Exception {
        DynamicResourceHandler handler = new DynamicResourceHandler();
        DynamicResourceUpdater sut = this.writeSessionFailureWithTerminationFailureSut(handler, session, snapshot);
        sut.run();
        this.verifyResult(snapshot, handler, true);
    }

    private void verifyResult(ResourceSnapshot snapshot, DynamicResourceHandler handler, boolean b) throws UnknownResourceException {
        DataSet dataSet = handler.get(snapshot);
        Individual resource = dataSet.individualOfId((Serializable)ManagedIndividualId.createId(RID, (String)"DynamicResourceHandler"));
        MatcherAssert.assertThat((Object)resource.hasProperty(DynamicResourceUpdater.REFRESHED_ON), (Matcher)Matchers.equalTo((Object)b));
    }

    private DynamicResourceUpdater workingSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) {
        this.delegate.setSession(session);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater runtimeFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) {
        this.delegate.setSession(session);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = new IllegalStateException("FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater nullWriteSessionSut(DynamicResourceHandler handler, WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        this.delegate.setSession(null);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater writeSessionCreationFailureSut(DynamicResourceHandler handler, WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        this.delegate.setSession(session);
        this.delegate.setFailure(true);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater writeSessionFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws WriteSessionException {
        this.delegate.setSession(session);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                session.saveChanges();
                this.result = new WriteSessionException();
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater writeSessionFailureWithTerminationFailureSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws Exception {
        this.delegate.setSession(session);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                session.saveChanges();
                this.result = new WriteSessionException("SAVE_FAILURE");
                session.close();
                this.result = new SessionTerminationException("CLOSE_FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater writeSessionTerminationSut(DynamicResourceHandler handler, final WriteSession session, final ResourceSnapshot snapshot) throws Exception {
        this.delegate.setSession(session);
        this.delegate.setFailure(false);
        new Expectations(){
            {
                snapshot.name();
                this.result = RID;
                session.find(ResourceSnapshot.class, RID, DynamicResourceHandler.class);
                this.result = snapshot;
                session.close();
                this.result = new SessionTerminationException("FAILURE");
            }
        };
        return this.createSut(handler);
    }

    private DynamicResourceUpdater createSut(DynamicResourceHandler handler) {
        DataSet dataSet = DataSets.createDataSet(RID);
        dataSet.individual((Serializable)ManagedIndividualId.createId(RID, (String)"DynamicResourceHandler"), ManagedIndividual.class);
        handler.add(RID, dataSet);
        return new DynamicResourceUpdater(handler, RID);
    }
}

