/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.example.InMemoryContainerHandler;
import org.ldp4j.example.NameProvider;

@RunWith(value=JMockit.class)
public class InMemoryContainerHandlerTest {
    private Name<String> name(String id) {
        return NamingScheme.getDefault().name((Serializable)((Object)id));
    }

    @Test
    public void tesNameProviderRoundtrip$happyPath(@Mocked NameProvider provider) throws Exception {
        Container container = new Container();
        Name<String> name = this.name("test");
        container.addNameProvider(name, provider);
        MatcherAssert.assertThat((Object)container.nameProvider(name), (Matcher)Matchers.sameInstance((Object)provider));
    }

    @Test
    public void tesNameProviderRoundtrip$exceptionPath(@Mocked NameProvider provider) throws Exception {
        Container container = new Container();
        Name<String> name = this.name("test");
        container.addNameProvider(name, provider);
        Name<String> unknown = this.name("unknown");
        try {
            container.nameProvider(unknown);
            Assert.fail((String)"Should not return provider for unknown resource");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Unknown container 'unknown'"));
        }
    }

    private static class Container
    extends InMemoryContainerHandler {
        protected Container() {
            super("container");
        }

        public ResourceSnapshot create(ContainerSnapshot container, DataSet representation, WriteSession session) {
            return null;
        }
    }
}

