/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.example.InMemoryResourceHandler;

@RunWith(value=JMockit.class)
public class InMemoryResourceHandlerTest {
    private Name<String> name(String id) {
        return NamingScheme.getDefault().name((Serializable)((Object)id));
    }

    @Test
    public void testCreation() throws Exception {
        Resource sut = new Resource();
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)sut.toString(), (Matcher)Matchers.equalTo((Object)"resource"));
    }

    @Test
    public void testResourceLifecycle(final @Mocked ResourceSnapshot s1, final @Mocked ResourceSnapshot s2, @Mocked DataSet r1, @Mocked DataSet r2) throws Exception {
        final Name<String> n1 = this.name("1");
        final Name<String> n2 = this.name("2");
        new Expectations(){
            {
                s1.name();
                this.result = n1;
                s2.name();
                this.result = n2;
            }
        };
        Resource sut = new Resource();
        sut.add(n1, r1);
        sut.add(n2, r2);
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)sut.get(s1), (Matcher)Matchers.sameInstance((Object)r1));
        MatcherAssert.assertThat((Object)sut.get(s2), (Matcher)Matchers.sameInstance((Object)r2));
        sut.remove(n2);
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)1));
        try {
            sut.get(s2);
            Assert.fail((String)"Resource 2 should not be available");
        }
        catch (UnknownResourceException e) {
            // empty catch block
        }
        sut.update(n1, r2);
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)sut.get(s1), (Matcher)Matchers.sameInstance((Object)r2));
    }

    @Test
    public void testUtilityMethods(@Mocked DataSet r1, @Mocked DataSet r2) throws Exception {
        Name<String> n1 = this.name("1");
        Name<String> n2 = this.name("2");
        Resource sut = new Resource();
        sut.add(n1, r1);
        sut.add(n2, r2);
        MatcherAssert.assertThat((Object)sut.hasResource(n1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)sut.hasResource(n2), (Matcher)Matchers.equalTo((Object)true));
        sut.remove(n2);
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)sut.hasResource(n2), (Matcher)Matchers.equalTo((Object)false));
        sut.clear();
        MatcherAssert.assertThat((Object)sut.size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)sut.hasResource(n1), (Matcher)Matchers.equalTo((Object)false));
    }

    private static class Resource
    extends InMemoryResourceHandler {
        protected Resource() {
            super("resource");
        }
    }
}

