/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import mockit.Expectations;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.Verifications;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ApplicationInitializationException;
import org.ldp4j.application.ext.Configuration;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.application.setup.Bootstrap;
import org.ldp4j.application.setup.Environment;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.example.DynamicResourceHandler;
import org.ldp4j.example.DynamicResourceResolver;
import org.ldp4j.example.DynamicResourceUpdater;
import org.ldp4j.example.MyApplication;
import org.ldp4j.example.PersonContainerHandler;
import org.ldp4j.example.PersonHandler;
import org.ldp4j.example.RelativeContainerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JMockit.class)
public class MyApplicationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyApplicationTest.class);
    private static final URI ENDPOINT = DynamicResourceResolver.CANONICAL_BASE.resolve("path/");
    @Mocked
    WriteSession initSession;
    @Mocked
    WriteSession resolverSession;
    @Mocked
    ResourceSnapshot snapshot;
    @Mocked
    ResourceSnapshot personSnapshot;
    @Mocked
    ContainerSnapshot personContainerSnapshot;
    @Mocked
    ResourceSnapshotResolver resolver;
    @Mocked
    ApplicationContext context;
    @Mocked
    RuntimeDelegate delegate;
    @Mocked
    Environment environment;
    @Mocked
    Bootstrap<Configuration> bootstrap;

    @Test
    public void testLifecycle() throws Exception {
        final MyApplication application = new MyApplication();
        LOGGER.info("Setting up application...");
        application.setup(this.environment, this.bootstrap);
        new Expectations(){
            {
                MyApplicationTest.this.resolverSession.find(ResourceSnapshot.class, application.dynamicResourceName(), DynamicResourceHandler.class);
                this.result = MyApplicationTest.this.snapshot;
                MyApplicationTest.this.snapshot.name();
                this.result = application.dynamicResourceName();
                MyApplicationTest.this.snapshot.templateId();
                this.result = "DynamicResourceHandler";
                MyApplicationTest.this.snapshot.handlerClass();
                this.result = DynamicResourceHandler.class;
                RuntimeDelegate.getInstance();
                this.result = MyApplicationTest.this.delegate;
                MyApplicationTest.this.delegate.createResourceResolver(DynamicResourceResolver.CANONICAL_BASE, (ReadSession)MyApplicationTest.this.resolverSession);
                this.result = MyApplicationTest.this.resolver;
                MyApplicationTest.this.resolver.resolve(MyApplicationTest.this.snapshot);
                this.result = ENDPOINT;
                MyApplicationTest.this.resolver.resolve(ENDPOINT);
                this.result = MyApplicationTest.this.snapshot;
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personResourceName(), PersonHandler.class);
                this.result = MyApplicationTest.this.personSnapshot;
                MyApplicationTest.this.personSnapshot.createAttachedResource(ContainerSnapshot.class, "personRelatives", application.relativeContainerResourceName(), RelativeContainerHandler.class);
                this.result = null;
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personContainerName(), PersonContainerHandler.class);
                this.result = MyApplicationTest.this.personContainerSnapshot;
            }
        };
        LOGGER.info("Initializing application...");
        application.initialize(this.initSession);
        LOGGER.info("Awaiting updater and resolver termination...");
        Stopwatch timer = Stopwatch.createStarted();
        while (timer.elapsed(TimeUnit.SECONDS) < 2L) {
        }
        LOGGER.info("Shutting down application...");
        application.shutdown();
        DataSet dataSet = application.dynamicResourceHandler().get(this.snapshot);
        LOGGER.info("Updated resource:\n{}", (Object)dataSet);
        Individual individual = dataSet.individualOfId((Serializable)this.individualId(application.dynamicResourceName()));
        MatcherAssert.assertThat((Object)individual.property(DynamicResourceUpdater.REFRESHED_ON).numberOfValues(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)individual.property(DynamicResourceResolver.SNAPSHOT_ENDPOINT).hasLiteralValue(Literals.newLiteral((Object)ENDPOINT)), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)individual.property(DynamicResourceResolver.SNAPSHOT_RESOLUTION).hasLiteralValue(Literals.of((String)"OK")), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testLifecycle$initalizeFailure() throws Exception {
        final MyApplication application = new MyApplication();
        LOGGER.info("Setting up application...");
        application.setup(this.environment, this.bootstrap);
        new Expectations(){
            {
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personResourceName(), PersonHandler.class);
                this.result = MyApplicationTest.this.personSnapshot;
                MyApplicationTest.this.personSnapshot.createAttachedResource(ContainerSnapshot.class, "personRelatives", application.relativeContainerResourceName(), RelativeContainerHandler.class);
                this.result = null;
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personContainerName(), PersonContainerHandler.class);
                this.result = MyApplicationTest.this.personContainerSnapshot;
                MyApplicationTest.this.initSession.saveChanges();
                this.result = new WriteSessionException("FAILURE");
            }
        };
        LOGGER.info("Initializing application...");
        try {
            application.initialize(this.initSession);
            Assert.fail((String)"Should not initialize the application if the session fails");
        }
        catch (ApplicationInitializationException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(WriteSessionException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
        }
    }

    @Test
    public void testLifecycle$shutdownFailure(final @Mocked ScheduledExecutorService executor) throws Exception {
        final MyApplication application = new MyApplication();
        new MockUp<Executors>(){

            @Mock
            public ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
                return executor;
            }
        };
        LOGGER.info("Setting up application...");
        application.setup(this.environment, this.bootstrap);
        new Expectations(){
            {
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personResourceName(), PersonHandler.class);
                this.result = MyApplicationTest.this.personSnapshot;
                MyApplicationTest.this.personSnapshot.createAttachedResource(ContainerSnapshot.class, "personRelatives", application.relativeContainerResourceName(), RelativeContainerHandler.class);
                this.result = null;
                MyApplicationTest.this.initSession.find(ResourceSnapshot.class, application.personContainerName(), PersonContainerHandler.class);
                this.result = MyApplicationTest.this.personContainerSnapshot;
                executor.isTerminated();
                this.result = false;
                executor.awaitTermination(this.anyLong, (TimeUnit)((Object)this.any));
                this.result = new InterruptedException("EXIT");
            }
        };
        LOGGER.info("Initializing application...");
        application.initialize(this.initSession);
        LOGGER.info("Shutting down application...");
        application.shutdown();
    }

    @Test
    public void testLogger(final @Mocked Logger logger) {
        MyApplication.LoggedUncaughtExceptionHandler sut = new MyApplication.LoggedUncaughtExceptionHandler(logger);
        final Thread t = Thread.currentThread();
        final IllegalStateException failure = new IllegalStateException();
        sut.uncaughtException(t, (Throwable)failure);
        new Verifications(){
            {
                logger.error(String.format("Thread %s died", t.getName()), (Throwable)failure);
            }
        };
    }

    private ManagedIndividualId individualId(Name<?> resourceName) {
        return ManagedIndividualId.createId(resourceName, (String)"DynamicResourceHandler");
    }
}

