/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.example.NameProvider;

public class NameProviderTest {
    private Name<String> name(String id) {
        return NamingScheme.getDefault().name((Serializable)((Object)id));
    }

    @Test
    public void testCreate$nonNull() throws Exception {
        Name<String> owner = this.name("test");
        NameProvider sut = NameProvider.create(owner);
        MatcherAssert.assertThat((Object)sut, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)sut.owner(), (Matcher)Matchers.equalTo(owner));
        MatcherAssert.assertThat((Object)sut.pendingMemberNames(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)sut.pendingResourceNames(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=NullPointerException.class)
    public void testCreate$null() throws Exception {
        NameProvider.create(null);
    }

    @Test
    public void testMemberNameLifecycle() {
        Name<String> owner = this.name("test");
        NameProvider sut = NameProvider.create(owner);
        sut.addMemberName(this.name("m1"));
        sut.addMemberName(this.name("m2"));
        MatcherAssert.assertThat((Object)sut.pendingMemberNames(), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m1"), this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextMemberName(), (Matcher)Matchers.equalTo(this.name("m1")));
        MatcherAssert.assertThat((Object)sut.pendingMemberNames(), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextMemberName(), (Matcher)Matchers.equalTo(this.name("m2")));
        MatcherAssert.assertThat((Object)sut.pendingMemberNames(), (Matcher)Matchers.hasSize((int)0));
        try {
            sut.nextMemberName();
            Assert.fail((String)"Should not provide member names if not available");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"No more member names available for resource 'test'"));
        }
    }

    @Test
    public void testResourceNameLifecycle() {
        Name<String> owner = this.name("test");
        NameProvider sut = NameProvider.create(owner);
        sut.addResourceName(this.name("m1"));
        sut.addResourceName(this.name("m2"));
        MatcherAssert.assertThat((Object)sut.pendingResourceNames(), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m1"), this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextResourceName(), (Matcher)Matchers.equalTo(this.name("m1")));
        MatcherAssert.assertThat((Object)sut.pendingResourceNames(), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextResourceName(), (Matcher)Matchers.equalTo(this.name("m2")));
        MatcherAssert.assertThat((Object)sut.pendingResourceNames(), (Matcher)Matchers.hasSize((int)0));
        try {
            sut.nextResourceName();
            Assert.fail((String)"Should not provide resource names if not available");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"No more resource names available for resource 'test'"));
        }
    }

    @Test
    public void testAttachmentNameLifecycle() {
        Name<String> owner = this.name("test");
        NameProvider sut = NameProvider.create(owner);
        sut.addAttachmentName("attachment", this.name("m1"));
        sut.addAttachmentName("attachment", this.name("m2"));
        MatcherAssert.assertThat((Object)sut.pendingAttachmentNames("attachment"), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m1"), this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextAttachmentName("attachment"), (Matcher)Matchers.equalTo(this.name("m1")));
        MatcherAssert.assertThat((Object)sut.pendingAttachmentNames("attachment"), (Matcher)Matchers.contains((Object[])new Name[]{this.name("m2")}));
        MatcherAssert.assertThat((Object)sut.nextAttachmentName("attachment"), (Matcher)Matchers.equalTo(this.name("m2")));
        MatcherAssert.assertThat((Object)sut.pendingAttachmentNames("attachment"), (Matcher)Matchers.hasSize((int)0));
        try {
            sut.nextAttachmentName("attachment");
            Assert.fail((String)"Should not provide attachment names if not available");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"No more attachment <<attachment>> names available for resource 'test'"));
        }
    }

    @Test
    public void testAttachmentNameLifecycle$unknownAttachment() {
        Name<String> owner = this.name("test");
        NameProvider sut = NameProvider.create(owner);
        MatcherAssert.assertThat((Object)sut.pendingAttachmentNames("attachment"), (Matcher)Matchers.hasSize((int)0));
        try {
            sut.nextAttachmentName("attachment");
            Assert.fail((String)"Should not provide attachment names if not available");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"No more attachment <<attachment>> names available for resource 'test'"));
        }
    }
}

