/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.example.PersonContainerHandler;
import org.ldp4j.example.PersonHandler;

@RunWith(value=JMockit.class)
public class PersonContainerHandlerTest {
    @Mocked
    WriteSession session;
    @Mocked
    ContainerSnapshot snapshot;
    @Mocked
    ResourceSnapshot memberSnapshot;

    private DataSet empty(Name<String> memberName) {
        DataSet data = DataSets.createDataSet(memberName);
        data.individual((Serializable)URI.create(""), NewIndividual.class);
        return data;
    }

    private Name<String> name(String string) {
        return NamingScheme.getDefault().name((Serializable)((Object)string));
    }

    @Test
    public void testCreate$happyPath() throws Exception {
        PersonContainerHandler containerHandler = new PersonContainerHandler();
        Deencapsulation.setField((Object)containerHandler, (String)"id", (Object)new AtomicInteger());
        PersonHandler resourceHandler = new PersonHandler();
        Name<String> containerName = this.name("container");
        containerHandler.setHandler(resourceHandler);
        DataSet data = this.empty(containerName);
        final Name memberName = NamingScheme.getDefault().name((Number)1);
        new Expectations(){
            {
                PersonContainerHandlerTest.this.memberSnapshot.name();
                this.result = memberName;
            }
        };
        containerHandler.create(this.snapshot, data, this.session);
        MatcherAssert.assertThat((Object)resourceHandler.get(this.memberSnapshot), (Matcher)Matchers.sameInstance((Object)data));
    }

    @Test
    public void testCreate$exceptionPath() throws Exception {
        PersonContainerHandler containerHandler = new PersonContainerHandler();
        Deencapsulation.setField((Object)containerHandler, (String)"id", (Object)new AtomicInteger());
        PersonHandler resourceHandler = new PersonHandler();
        Name<String> containerName = this.name("container");
        containerHandler.setHandler(resourceHandler);
        DataSet data = this.empty(containerName);
        final Name memberName = NamingScheme.getDefault().name((Number)1);
        new Expectations(){
            {
                PersonContainerHandlerTest.this.memberSnapshot.name();
                this.result = memberName;
                PersonContainerHandlerTest.this.session.saveChanges();
                this.result = new WriteSessionException("FAILURE");
            }
        };
        try {
            containerHandler.create(this.snapshot, data, this.session);
            Assert.fail((String)"Should not create if the session fails");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(WriteSessionException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
            try {
                resourceHandler.get(this.memberSnapshot);
                Assert.fail((String)"Resource should not be available in the resource handler");
            }
            catch (UnknownResourceException e1) {
                // empty catch block
            }
        }
    }
}

