/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.InconsistentContentException;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.example.PersonHandler;

@RunWith(value=JMockit.class)
public class PersonHandlerTest {
    @Mocked
    WriteSession session;
    @Mocked
    ResourceSnapshot snapshot;

    private DataSet withReadOnlyProperty(Name<String> resourceName) {
        DataSet data = this.empty(resourceName);
        ManagedIndividual individual = (ManagedIndividual)data.individual((Serializable)ManagedIndividualId.createId(resourceName, (String)"personTemplate"), ManagedIndividual.class);
        individual.addValue(PersonHandler.READ_ONLY_PROPERTY, (Value)Literals.of((String)"value"));
        return data;
    }

    private DataSet empty(Name<String> memberName) {
        DataSet data = DataSets.createDataSet(memberName);
        data.individual((Serializable)URI.create(""), NewIndividual.class);
        return data;
    }

    private Name<String> name(String string) {
        return NamingScheme.getDefault().name((Serializable)((Object)string));
    }

    @Test
    public void testDeletion$happyPath() throws Exception {
        PersonHandler sut = new PersonHandler();
        final Name<String> resourceName = this.name("resource");
        DataSet data = this.empty(resourceName);
        sut.add(resourceName, data);
        new Expectations(){
            {
                PersonHandlerTest.this.snapshot.name();
                this.result = resourceName;
                PersonHandlerTest.this.session.delete(PersonHandlerTest.this.snapshot);
                PersonHandlerTest.this.session.saveChanges();
            }
        };
        sut.delete(this.snapshot, this.session);
        try {
            MatcherAssert.assertThat((Object)sut.get(this.snapshot), (Matcher)Matchers.sameInstance((Object)data));
            Assert.fail((String)"Should be deleted if the operation succeeds");
        }
        catch (UnknownResourceException e) {
            // empty catch block
        }
    }

    @Test
    public void testDeletion$fail() throws Exception {
        PersonHandler sut = new PersonHandler();
        final Name<String> resourceName = this.name("resource");
        DataSet data = this.empty(resourceName);
        sut.add(resourceName, data);
        new Expectations(){
            {
                PersonHandlerTest.this.snapshot.name();
                this.result = resourceName;
                PersonHandlerTest.this.session.delete(PersonHandlerTest.this.snapshot);
                PersonHandlerTest.this.session.saveChanges();
                this.result = new WriteSessionException("FAILURE");
            }
        };
        try {
            sut.delete(this.snapshot, this.session);
            Assert.fail((String)"Should not delete if the session fails");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(WriteSessionException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
            MatcherAssert.assertThat((Object)sut.get(this.snapshot), (Matcher)Matchers.sameInstance((Object)data));
        }
    }

    @Test
    public void testUpdate$happyPath() throws Exception {
        PersonHandler sut = new PersonHandler();
        final Name<String> resourceName = this.name("resource");
        DataSet data = this.withReadOnlyProperty(resourceName);
        sut.add(resourceName, data);
        new Expectations(){
            {
                PersonHandlerTest.this.snapshot.name();
                this.result = resourceName;
                PersonHandlerTest.this.session.modify(PersonHandlerTest.this.snapshot);
            }
        };
        DataSet modified = this.withReadOnlyProperty(resourceName);
        sut.update(this.snapshot, modified, this.session);
        MatcherAssert.assertThat((Object)sut.get(this.snapshot), (Matcher)Matchers.sameInstance((Object)modified));
    }

    @Test
    public void testUpdate$sessionFailure() throws Exception {
        PersonHandler sut = new PersonHandler();
        final Name<String> resourceName = this.name("resource");
        DataSet data = this.empty(resourceName);
        sut.add(resourceName, data);
        new Expectations(){
            {
                PersonHandlerTest.this.snapshot.name();
                this.result = resourceName;
                PersonHandlerTest.this.session.modify(PersonHandlerTest.this.snapshot);
                PersonHandlerTest.this.session.saveChanges();
                this.result = new WriteSessionException("FAILURE");
            }
        };
        try {
            sut.update(this.snapshot, this.empty(resourceName), this.session);
            Assert.fail((String)"Should not modify if the session fails");
        }
        catch (ApplicationRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(WriteSessionException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
            MatcherAssert.assertThat((Object)sut.get(this.snapshot), (Matcher)Matchers.sameInstance((Object)data));
        }
    }

    @Test
    public void testUpdate$validationFailure() throws Exception {
        PersonHandler sut = new PersonHandler();
        final Name<String> resourceName = this.name("resource");
        DataSet data = this.withReadOnlyProperty(resourceName);
        sut.add(resourceName, data);
        new Expectations(){
            {
                PersonHandlerTest.this.snapshot.name();
                this.result = resourceName;
            }
        };
        try {
            sut.update(this.snapshot, this.empty(resourceName), this.session);
            Assert.fail((String)"Should not modify if the session fails");
        }
        catch (InconsistentContentException e) {
            MatcherAssert.assertThat((Object)sut.get(this.snapshot), (Matcher)Matchers.sameInstance((Object)data));
        }
    }
}

