/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSetHelper;
import org.ldp4j.application.data.DataSetUtils;
import org.ldp4j.application.data.IndividualHelper;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.ext.InvalidQueryException;
import org.ldp4j.application.ext.ObjectTransformationException;
import org.ldp4j.application.ext.Query;
import org.ldp4j.application.sdk.QueryBuilder;
import org.ldp4j.commons.testing.Utils;
import org.ldp4j.example.QuerySupport;

public class QuerySupportTest {
    @Test
    public void verifyIsUtilityClass() {
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(QuerySupport.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testGetDescription() throws Exception {
        Name id = NamingScheme.getDefault().name((Serializable)((Object)"Test"));
        Query query = QueryBuilder.newInstance().withParameter("param1", (Object)"value1").withParameter("param1", (Object)"value2").withParameter("param2", (Object)"value1").build();
        DataSet data = QuerySupport.getDescription((Name)id, (Query)query);
        MatcherAssert.assertThat((Object)data.name(), (Matcher)Matchers.sameInstance((Object)id));
        DataSetHelper dHelper = DataSetUtils.newHelper((DataSet)data);
        IndividualHelper qInd = dHelper.localIndividual(QuerySupport.queryId());
        MatcherAssert.assertThat((Object)qInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.QUERY_TYPE}));
        IndividualHelper pInd = dHelper.localIndividual(QuerySupport.parameterId((String)"param1"));
        MatcherAssert.assertThat((Object)pInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.PARAMETER_TYPE}));
    }

    @Test
    public void testGetDescription$failureRequest$happyPath() throws Exception {
        Name id = NamingScheme.getDefault().name((Serializable)((Object)"Test"));
        Query query = QueryBuilder.newInstance().withParameter("failure", (Object)"true").build();
        try {
            QuerySupport.getDescription((Name)id, (Query)query);
            Assert.fail((String)"Should not accept queries with the failure parameter set to true");
        }
        catch (InvalidQueryException e) {
            MatcherAssert.assertThat((Object)e.getQuery(), (Matcher)Matchers.equalTo((Object)query));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testGetDescription$failureRequest$otherPath() throws Exception {
        Name id = NamingScheme.getDefault().name((Serializable)((Object)"Test"));
        Query query = QueryBuilder.newInstance().withParameter("failure", (Object)"FALSE").build();
        DataSet data = QuerySupport.getDescription((Name)id, (Query)query);
        MatcherAssert.assertThat((Object)data.name(), (Matcher)Matchers.sameInstance((Object)id));
        DataSetHelper dHelper = DataSetUtils.newHelper((DataSet)data);
        IndividualHelper qInd = dHelper.localIndividual(QuerySupport.queryId());
        MatcherAssert.assertThat((Object)qInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.QUERY_TYPE}));
        IndividualHelper pInd = dHelper.localIndividual(QuerySupport.parameterId((String)"failure"));
        MatcherAssert.assertThat((Object)pInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.PARAMETER_TYPE}));
    }

    @Test
    public void testGetDescription$failureRequest$invalidValue() throws Exception {
        Name id = NamingScheme.getDefault().name((Serializable)((Object)"Test"));
        Query query = QueryBuilder.newInstance().withParameter("failure", (Object)"not a boolean").build();
        try {
            QuerySupport.getDescription((Name)id, (Query)query);
            Assert.fail((String)"Should not accept queries with the failure parameter");
        }
        catch (InvalidQueryException e) {
            MatcherAssert.assertThat((Object)e.getQuery(), (Matcher)Matchers.equalTo((Object)query));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ObjectTransformationException.class));
        }
    }

    @Test
    public void testGetValueLessParameterDescription() throws Exception {
        Name id = NamingScheme.getDefault().name((Serializable)((Object)"Test"));
        Query query = QueryBuilder.newInstance().withParameter("param1", (Object)"").withParameter("param1", (Object)"").withParameter("param2", (Object)"value1").build();
        DataSet data = QuerySupport.getDescription((Name)id, (Query)query);
        MatcherAssert.assertThat((Object)data.name(), (Matcher)Matchers.sameInstance((Object)id));
        DataSetHelper dHelper = DataSetUtils.newHelper((DataSet)data);
        IndividualHelper qInd = dHelper.localIndividual(QuerySupport.queryId());
        MatcherAssert.assertThat((Object)qInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.QUERY_TYPE}));
        IndividualHelper pInd = dHelper.localIndividual(QuerySupport.parameterId((String)"param1"));
        MatcherAssert.assertThat((Object)pInd.types(), (Matcher)Matchers.contains((Object[])new URI[]{QuerySupport.PARAMETER_TYPE}));
    }
}

