/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.annotations.IndirectContainer;
import org.ldp4j.application.ext.annotations.MembershipRelation;
import org.ldp4j.application.session.ContainerSnapshot;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.example.BookHandler;
import org.ldp4j.example.InMemoryContainerHandler;
import org.ldp4j.example.NameProvider;

@IndirectContainer(id="bookContainerTemplate", memberHandler=BookHandler.class, membershipRelation=MembershipRelation.HAS_MEMBER, membershipPredicate="http://www.ldp4j.org/vocabularies/example#hasBook", insertedContentRelation="http://www.ldp4j.org/vocabularies/example#bookshelf")
public class BookContainerHandler
extends InMemoryContainerHandler {
    public static final String INSERTED_CONTENT_RELATION = "http://www.ldp4j.org/vocabularies/example#bookshelf";
    public static final String ID = "bookContainerTemplate";
    private BookHandler handler;

    public BookContainerHandler() {
        super("BookContainer");
    }

    public void setBookHandler(BookHandler handler) {
        this.handler = handler;
    }

    public BookHandler bookHandler() {
        if (this.handler == null) {
            throw new IllegalStateException("Handler not initialized yet");
        }
        return this.handler;
    }

    public ResourceSnapshot create(ContainerSnapshot container, DataSet representation, WriteSession session) {
        NameProvider nameProvider = this.nameProvider(container.name());
        Name<String> nextName = nameProvider.nextMemberName();
        try {
            this.bookHandler().add(nextName, representation);
            ResourceSnapshot newMember = container.addMember(nextName);
            session.saveChanges();
            return newMember;
        }
        catch (Exception e) {
            this.bookHandler().remove(nextName);
            throw new ApplicationRuntimeException("Could not create member", (Throwable)e);
        }
    }
}

