/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import com.google.common.collect.Maps;
import java.util.Map;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.ContainerHandler;
import org.ldp4j.example.InMemoryResourceHandler;
import org.ldp4j.example.NameProvider;

public abstract class InMemoryContainerHandler
extends InMemoryResourceHandler
implements ContainerHandler {
    private final Map<Name<String>, NameProvider> nameProviders = Maps.newLinkedHashMap();

    protected InMemoryContainerHandler(String handlerName) {
        super(handlerName);
    }

    public final void addNameProvider(Name<String> containerName, NameProvider provider) {
        this.nameProviders.put(containerName, provider);
    }

    public final NameProvider nameProvider(Name<?> containerName) {
        NameProvider result = this.nameProviders.get(containerName);
        if (result == null) {
            throw new ApplicationRuntimeException("Unknown container '" + containerName + "'");
        }
        return result;
    }
}

