/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ResourceHandler;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;

public abstract class InMemoryResourceHandler
implements ResourceHandler {
    private final String handlerName;
    private final Map<Name<?>, DataSet> resources;

    protected InMemoryResourceHandler(String handlerName) {
        this.handlerName = handlerName;
        this.resources = new LinkedHashMap();
    }

    protected final String getHandlerName() {
        return this.handlerName;
    }

    public DataSet get(ResourceSnapshot resource) throws UnknownResourceException {
        DataSet dataSet = this.resources.get(resource.name());
        if (dataSet == null) {
            throw new UnknownResourceException("Unknown resource '" + resource.name() + "'");
        }
        return dataSet;
    }

    public final void add(Name<?> name, DataSet data) {
        this.resources.put(name, data);
    }

    public final void update(Name<?> name, DataSet data) {
        this.remove(name);
        this.add(name, data);
    }

    public final void clear() {
        this.resources.clear();
    }

    public final int size() {
        return this.resources.size();
    }

    public final void remove(Name<?> name) {
        this.resources.remove(name);
    }

    public final boolean hasResource(Name<?> resourceName) {
        return this.resources.containsKey(resourceName);
    }

    public String toString() {
        return this.getHandlerName();
    }
}

