/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.constraints.Constraints;
import org.ldp4j.application.data.validation.ValidationConstraint;
import org.ldp4j.application.data.validation.ValidationConstraintFactory;
import org.ldp4j.application.data.validation.ValidationReport;
import org.ldp4j.application.data.validation.Validator;
import org.ldp4j.application.ext.ApplicationRuntimeException;
import org.ldp4j.application.ext.Deletable;
import org.ldp4j.application.ext.InconsistentContentException;
import org.ldp4j.application.ext.Modifiable;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.ext.annotations.Attachment;
import org.ldp4j.application.ext.annotations.Resource;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.example.AddressHandler;
import org.ldp4j.example.BookContainerHandler;
import org.ldp4j.example.InMemoryResourceHandler;
import org.ldp4j.example.RelativeContainerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource(id="personTemplate", attachments={@Attachment(id="address", path="address", predicate="http://www.ldp4j.org/vocabularies/example#address", handler=AddressHandler.class), @Attachment(id="books", path="books", handler=BookContainerHandler.class), @Attachment(id="personRelatives", path="relatives", handler=RelativeContainerHandler.class)})
public class PersonHandler
extends InMemoryResourceHandler
implements Modifiable,
Deletable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonHandler.class);
    public static final String ID = "personTemplate";
    public static final String RELATIVES_ID = "personRelatives";
    public static final String RELATIVES_PATH = "relatives";
    public static final String ADDRESS_ID = "address";
    public static final String ADDRESS_PATH = "address";
    public static final URI READ_ONLY_PROPERTY = URI.create("http://www.example.org/vocab#creationDate");

    public PersonHandler() {
        super("Person");
    }

    public void delete(ResourceSnapshot resource, WriteSession session) throws UnknownResourceException {
        DataSet dataSet = this.get(resource);
        try {
            this.logDebug(resource, "Deleting state:%n%s", dataSet);
            this.remove(resource.name());
            session.delete(resource);
            session.saveChanges();
        }
        catch (WriteSessionException e) {
            this.add(resource.name(), dataSet);
            throw new ApplicationRuntimeException("Deletion failed", (Throwable)e);
        }
    }

    public void update(ResourceSnapshot resource, DataSet content, WriteSession session) throws InconsistentContentException, UnknownResourceException {
        DataSet dataSet = this.get(resource);
        this.logDebug(resource, "Enforcing consistency...", new Object[0]);
        this.enforceConsistency(resource, content, dataSet);
        try {
            this.logDebug(resource, "Persisting new state:%n%s", content);
            this.add(resource.name(), content);
            session.modify(resource);
            session.saveChanges();
        }
        catch (Exception e) {
            this.add(resource.name(), dataSet);
            this.logError(resource, e, "Something went wrong", e);
            throw new ApplicationRuntimeException("Update failed", (Throwable)e);
        }
    }

    protected void logDebug(ResourceSnapshot resource, String message, Object ... args) {
        LOGGER.debug("[{}] {}", (Object)resource.name(), (Object)String.format(message, args));
    }

    protected void logError(ResourceSnapshot resource, Throwable t, String message, Object ... args) {
        LOGGER.error("[{}] {}", new Object[]{resource.name(), String.format(message, args), t});
    }

    protected void enforceConsistency(ResourceSnapshot resource, DataSet content, DataSet dataSet) throws InconsistentContentException {
        ManagedIndividualId id = ManagedIndividualId.createId((Name)resource.name(), (String)ID);
        ManagedIndividual stateIndividual = (ManagedIndividual)dataSet.individual((Serializable)id, ManagedIndividual.class);
        Property stateProperty = stateIndividual.property(READ_ONLY_PROPERTY);
        ValidationConstraint constraint = null;
        constraint = stateProperty != null ? ValidationConstraintFactory.readOnlyProperty((Property)stateProperty) : ValidationConstraintFactory.readOnlyProperty((Object)id, (URI)READ_ONLY_PROPERTY, (Value[])new Value[0]);
        Validator helper = Validator.builder().withPropertyConstraint(constraint).build();
        ValidationReport report = helper.validate(content);
        if (!report.isValid()) {
            InconsistentContentException error = new InconsistentContentException("Validation failed: " + report.validationFailures(), Constraints.constraints());
            this.logError(resource, (Throwable)error, "Something went wrong when validating %n%s", content);
            throw error;
        }
    }
}

