/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.example;

import java.io.Serializable;
import java.net.URI;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.DataSets;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.LocalIndividual;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NamingScheme;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.ext.InvalidQueryException;
import org.ldp4j.application.ext.ObjectTransformationException;
import org.ldp4j.application.ext.Parameter;
import org.ldp4j.application.ext.Query;
import org.ldp4j.application.vocabulary.RDF;

final class QuerySupport {
    public static final String NAMESPACE = "http://www.ldp4j.org/examples#";
    public static final URI QUERY_TYPE = URI.create("http://www.ldp4j.org/examples#Query");
    public static final URI PARAMETER_TYPE = URI.create("http://www.ldp4j.org/examples#Parameter");
    public static final URI HAS_PARAMETER = URI.create("http://www.ldp4j.org/examples#hasParameter");
    public static final URI HAS_VALUE = URI.create("http://www.ldp4j.org/examples#hasValue");
    public static final URI HAS_NAME = URI.create("http://www.ldp4j.org/examples#hasName");
    private static final URI TYPE = (URI)RDF.TYPE.as(URI.class);

    private QuerySupport() {
    }

    static DataSet getDescription(Name<?> id, Query query) throws InvalidQueryException {
        DataSet dataset = DataSets.createDataSet(id);
        if (query.hasParameter("failure")) {
            Parameter failure = query.getParameter("failure");
            try {
                if (((Boolean)failure.rawValueAs(Boolean.class)).booleanValue()) {
                    throw new InvalidQueryException("Failure requested", query);
                }
            }
            catch (ObjectTransformationException e) {
                throw new InvalidQueryException("Could not understand: '" + failure.rawValue() + "' is not a valid boolean value for parameter '" + "failure" + "'", (Throwable)e, query);
            }
        }
        LocalIndividual qIndividual = (LocalIndividual)dataset.individual((Serializable)QuerySupport.queryId(), LocalIndividual.class);
        ExternalIndividual qtIndividual = (ExternalIndividual)dataset.individual((Serializable)QUERY_TYPE, ExternalIndividual.class);
        ExternalIndividual ptIndividual = (ExternalIndividual)dataset.individual((Serializable)PARAMETER_TYPE, ExternalIndividual.class);
        qIndividual.addValue(TYPE, (Value)qtIndividual);
        for (String parameterName : query.parameterNames()) {
            LocalIndividual pIndividual = (LocalIndividual)dataset.individual((Serializable)QuerySupport.parameterId(parameterName), LocalIndividual.class);
            qIndividual.addValue(HAS_PARAMETER, (Value)pIndividual);
            pIndividual.addValue(TYPE, (Value)ptIndividual);
            pIndividual.addValue(HAS_NAME, (Value)Literals.of((String)parameterName));
            for (String rawValue : query.getParameter(parameterName).rawValues()) {
                pIndividual.addValue(HAS_VALUE, (Value)Literals.of((String)rawValue));
            }
        }
        return dataset;
    }

    static Name parameterId(String parameterName) {
        return NamingScheme.getDefault().name("parameter", new String[]{parameterName});
    }

    static Name queryId() {
        return NamingScheme.getDefault().name((Serializable)((Object)"query"));
    }
}

