/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ldp4j.application.ext.Namespaces;

public final class ImmutableNamespaces
implements Namespaces {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final Map<String, String> map;

    private ImmutableNamespaces(Map<String, String> map) {
        this.map = Maps.newHashMap(map);
    }

    public ImmutableNamespaces() {
        this(Maps.newLinkedHashMap());
    }

    public ImmutableNamespaces withPrefix(String prefix, String namespaceURI) {
        ImmutableNamespaces result = new ImmutableNamespaces(this.map);
        result.map.put(prefix, namespaceURI);
        return result;
    }

    public ImmutableNamespaces withoutPrefix(String ... prefixes) {
        ImmutableNamespaces result = new ImmutableNamespaces(this.map);
        for (String prefix : prefixes) {
            result.map.remove(prefix);
        }
        return result;
    }

    public Set<String> getDeclaredPrefixes() {
        return ImmutableSet.copyOf(this.map.keySet());
    }

    public String getNamespaceURI(String prefix) {
        String namespaceURI = this.map.get(prefix);
        return namespaceURI == null ? null : namespaceURI.toString();
    }

    public String getPrefix(String namespaceURI) {
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<String> getPrefixes(String namespaceURI) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Namespaces {");
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String namespaceURI = entry.getValue();
            String prefix = entry.getKey();
            String line = String.format("  - \"%s\" : \"%s\" [%s]", prefix, namespaceURI, namespaceURI.getClass().getName());
            builder.append(LINE_SEPARATOR).append(line);
        }
        if (!this.map.isEmpty()) {
            builder.append(LINE_SEPARATOR);
        }
        builder.append("}");
        return builder.toString();
    }
}

