/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.application.util.ImmutableNamespaces;
import org.ldp4j.commons.testing.Utils;

public class ImmutableNamespacesTest {
    private static final String DEFAULT_PR2 = "pr2";
    private static final String DEFAULT_PR1 = "pr1";
    private static final String DEFAULT_NAMESPACE = "http://www.example.org/vocabulary1#";
    private static final String NS1 = "ns1";
    private static final String VALID_NAMESPACE = "http://www.example.org/vocabulary#";
    private ImmutableNamespaces sut;

    @Before
    public void setUp() {
        this.sut = new ImmutableNamespaces().withPrefix(DEFAULT_PR1, DEFAULT_NAMESPACE).withPrefix(DEFAULT_PR2, DEFAULT_NAMESPACE);
    }

    @Test
    public void testWithPrefix$valid() throws Exception {
        ImmutableNamespaces ns = this.sut.withPrefix(NS1, VALID_NAMESPACE);
        MatcherAssert.assertThat((Object)ns, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)this.sut)));
        MatcherAssert.assertThat((Object)ns.getDeclaredPrefixes(), (Matcher)Matchers.contains((Object[])new String[]{NS1, DEFAULT_PR1, DEFAULT_PR2}));
        MatcherAssert.assertThat((Object)ns.getNamespaceURI(NS1), (Matcher)Matchers.equalTo((Object)VALID_NAMESPACE));
        MatcherAssert.assertThat((Object)ns.getPrefix(VALID_NAMESPACE), (Matcher)Matchers.equalTo((Object)NS1));
        MatcherAssert.assertThat((Object)ns.getPrefixes(VALID_NAMESPACE), (Matcher)Matchers.contains((Object[])new String[]{NS1}));
    }

    @Test(expected=NullPointerException.class)
    public void testWithPrefix$nullPrefix() throws Exception {
        this.sut.withPrefix(null, VALID_NAMESPACE);
    }

    @Test(expected=NullPointerException.class)
    public void testWithPrefix$nullNamespace() throws Exception {
        this.sut.withPrefix(NS1, null);
    }

    @Test
    public void testWithoutPrefix() throws Exception {
        ImmutableNamespaces ns = this.sut.withoutPrefix(new String[]{DEFAULT_PR1, DEFAULT_PR2});
        MatcherAssert.assertThat((Object)ns, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)this.sut)));
        MatcherAssert.assertThat((Object)ns.getDeclaredPrefixes(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetDeclaredPrefixes() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getDeclaredPrefixes(), (Matcher)Matchers.contains((Object[])new String[]{DEFAULT_PR1, DEFAULT_PR2}));
    }

    @Test
    public void testGetNamespaceURI() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getNamespaceURI(DEFAULT_PR1), (Matcher)Matchers.equalTo((Object)DEFAULT_NAMESPACE));
        MatcherAssert.assertThat((Object)this.sut.getNamespaceURI(DEFAULT_PR2), (Matcher)Matchers.equalTo((Object)DEFAULT_NAMESPACE));
    }

    @Test
    public void testGetPrefix$found() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getPrefix(DEFAULT_NAMESPACE), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)DEFAULT_PR1), (Matcher)Matchers.equalTo((Object)DEFAULT_PR2)));
    }

    @Test
    public void testGetPrefix$notFound() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getPrefix("not found"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetPrefixes$found() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getPrefixes(DEFAULT_NAMESPACE), (Matcher)Matchers.contains((Object[])new String[]{DEFAULT_PR1, DEFAULT_PR2}));
    }

    @Test
    public void testGetPrefixes$notFound() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.getPrefixes("not found"), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testToString$empty() throws Exception {
        ImmutableNamespaces ns = new ImmutableNamespaces();
        MatcherAssert.assertThat((Object)ns.toString(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)Utils.defaultToString((Object)ns))));
    }

    @Test
    public void testToString$nonEmpty() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.toString(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)Utils.defaultToString((Object)this.sut))));
    }
}

