/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core;

import jmms.core.model.MetaApi;
import leap.db.Db;
import leap.lang.json.JsonObject;
import leap.orm.OrmContext;
import leap.web.api.dyna.DynaApi;
import leap.web.api.meta.ApiMetadata;
import leap.web.route.Routes;

public abstract class Api {

    protected static volatile Api current;

    /**
     * Returns current api or null.
     */
    public static Api current() {
        return current;
    }

    /**
     * Returns current api.
     *
     * @throws IllegalStateException if no current api.
     */
    public static Api mustGetCurrent() {
        if(null == current) {
            throw new IllegalStateException("No current api");
        }
        return current;
    }

    /**
     * Returns the meta object of this {@link Api}.
     */
    public abstract MetaApi getMeta();

    /**
     * Returns the runtime api.
     */
    public abstract DynaApi getDyna();

    /**
     * Returns the db instance of this api.
     */
    public abstract Db getDb();

    /**
     * Returns the orm context of this api.
     */
    public abstract OrmContext getOrmContext();

    /**
     * Returns the {@link JsonObject} represents the swagger spec of api.
     */
    public abstract JsonObject getSwagger();

    /**
     * Returns the {@link ApiMetadata} of api.
     */
    public ApiMetadata getMetadata() {
        return getDyna().getMetadata();
    }
}
