/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;
import leap.lang.Strings;
import leap.lang.meta.annotation.Filterable;
import leap.lang.meta.annotation.Sortable;

public class MetaApiKey {

    @Required @Filterable @Sortable
    protected String name;

    @Sortable @Filterable
    protected String version;

    public MetaApiKey() {

    }

    public MetaApiKey(String name) {
        this.name    = name;
        this.version = "";
    }

    public MetaApiKey(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toKeyString() {
        return Strings.isEmpty(version) ? name.toLowerCase() : name.toLowerCase() + "___" + version.toLowerCase();
    }

    public MetaApiKey decodeKeyString(String ks) {
        int index = ks.lastIndexOf("___");
        if(index > 0) {
            this.name = ks.substring(0, index);
            this.version = ks.substring(index+1);
        }else{
            this.name = ks;
        }
        return this;
    }

}