/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.exception.ObjectExistsException;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MetaEntitySet {

    protected final Map<String, MetaEntity> entities = new LinkedHashMap<>();

    public MetaEntitySet() {

    }

    public MetaEntitySet(Map<String, MetaEntity> entities) {
        this.entities.putAll(entities);
    }

    public Map<String, MetaEntity> all() {
        return entities;
    }

    public void add(MetaEntity model) throws ObjectExistsException {
        String key = model.getName().toLowerCase();
        if(entities.containsKey(key)) {
            throw new ObjectExistsException("Model '" + model.getName() + "' already exists!");
        }
        entities.put(key, model);
    }

    public MetaEntity getEntity(String name) {
        return entities.get(name.toLowerCase());
    }

    public MetaEntity getByTable(String tableName) throws IllegalStateException {
        List<MetaEntity> found = new ArrayList<>();

        for(MetaEntity model : entities.values()) {
            if(model.getTable().equalsIgnoreCase(tableName)) {
                found.add(model);
            }
        }

        if(found.size() > 1) {
            throw new IllegalStateException("Found '" + found.size() + "' models with the table name '" + tableName + "'");
        }

        if(found.size() == 1) {
            return found.get(0);
        }

        return null;
    }

}
