/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.collection.WrappedCaseInsensitiveMap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MetaFakeCategory extends MetaObjNamed {

    protected Boolean                   basic;
    protected List<String>              aliases = new ArrayList<>();
    protected Map<String, MetaFakeItem> items   = WrappedCaseInsensitiveMap.create();

    public boolean isBasic() {
        return null != basic && basic;
    }

    public Boolean getBasic() {
        return basic;
    }

    public void setBasic(Boolean basic) {
        this.basic = basic;
    }

    public List<String> getAliases() {
        return aliases;
    }

    public void addAlias(String alias) {
        aliases.add(alias);
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, MetaFakeItem> getItems() {
        return items;
    }

    public void setItems(Map<String, MetaFakeItem> items) {
        this.items = WrappedCaseInsensitiveMap.create(items);
    }

    public MetaFakeItem getItem(String name) {
        return items.get(name);
    }

    public void addItem(MetaFakeItem p) {
        items.put(p.getName(), p);
    }

    public void addItems(Collection<MetaFakeItem> c) {
        c.forEach(this::addItem);
    }

}