/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;
import leap.lang.annotation.Order;
import leap.lang.convert.StringParsable;

import java.util.ArrayList;
import java.util.List;

public class MetaFakeItem extends MetaObjNamed implements StringParsable {

    @Required @Order(1)
    protected String id;

    /**
     * Is the name unique?
     */
    protected Boolean unique;

    /**
     * The unique keys.
     */
    protected List<String> keys = new ArrayList<>();

    /**
     * The alias names.
     */
    protected List<String> aliases = new ArrayList<>();

    /**
     * The sample data.
     */
    protected List<Object> samples = new ArrayList<>();

    protected String expr;

    protected String uniqueExpr;

    public String id(String category, String name) {
        return category + "." + name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isUnique() {
        return null != unique && unique;
    }

    public Boolean getUnique() {
        return unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public List<String> getKeys() {
        return keys;
    }

    public void addKey(String key) {
        keys.add(key);
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public List<String> getAliases() {
        return aliases;
    }

    public void addAlias(String alias) {
        aliases.add(alias);
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public List<Object> getSamples() {
        return samples;
    }

    public void addSample(Object sample) {
        samples.add(sample);
    }

    public void setSamples(List<Object> samples) {
        this.samples = samples;
    }

    public String getExpr() {
        return expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public String getUniqueExpr() {
        return uniqueExpr;
    }

    public void setUniqueExpr(String uniqueExpr) {
        this.uniqueExpr = uniqueExpr;
    }

    @Override
    public void parseString(String s) {
        this.expr = s;
    }
}