/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.json.JsonIgnore;
import leap.lang.meta.MType;

public abstract class MetaObjFormatted extends MetaObjNamed {

    protected Boolean required;

    @JsonIgnore
    protected MetaFormat resolvedFormat;

    public boolean isRequired() {
        return null != required && required;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public MetaFormat getResolvedFormat() {
        return resolvedFormat;
    }

    public void setResolvedFormat(MetaFormat resolvedFormat) {
        this.resolvedFormat = resolvedFormat;
    }

    public MType getResolvedType() {
        return null;
    }
}