/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import java.util.LinkedHashMap;
import java.util.Map;

import leap.core.validation.annotations.Required;
import leap.lang.annotation.Order;

public class MetaObjNamed extends MetaObjTitled {

    @Required @Order(7)
    protected String name;

    @Order(1001)
    protected Map<String, Object> owner;

    @Order(1002)
    protected Map<String, Object> attrs;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameAndTitle(String nameAndTitle) {
        setName(nameAndTitle);
        setTitle(nameAndTitle);
    }

    public Map<String, Object> getOwner() {
        return owner;
    }

    public void setOwner(Map<String, Object> owner) {
        this.owner = owner;
    }

    public Map<String, Object> getAttrs() {
        return attrs;
    }

    public void setAttr(String name, Object value) {
        if(null == attrs) {
            attrs = new LinkedHashMap<>();
        }
        attrs.put(name, value);
    }

    public void setAttrs(Map<String, Object> attrs) {
        this.attrs = attrs;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + getName() + ")";
    }
}