/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.json.JsonName;

import java.util.regex.Pattern;

public class MetaObjValidated extends MetaObjFormatted {

    protected Pattern pattern;

    protected Integer maxLength;
    protected Integer minLength;

    @JsonName("default")
    protected Object defaults;

    @JsonName("enum")
    protected String[] enums;

    protected Number  maximum;
    protected Boolean exclusiveMaximum;

    protected Number  minimum;
    protected Boolean exclusiveMinimum;

    protected Integer  maxItems;
    protected Integer  minItems;

    //todo: implements
    protected Boolean  uniqueItems;

    //todo: implements
    protected Number   multipleOf;

    public Pattern getPattern() {
        return pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Object getDefaults() {
        return defaults;
    }

    public void setDefaults(Object defaults) {
        this.defaults = defaults;
    }

    public String[] getEnums() {
        return enums;
    }

    public void setEnums(String[] enums) {
        this.enums = enums;
    }

    public Number getMaximum() {
        return maximum;
    }

    public void setMaximum(Number maximum) {
        this.maximum = maximum;
    }

    public Boolean getExclusiveMaximum() {
        return exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public Number getMinimum() {
        return minimum;
    }

    public void setMinimum(Number minimum) {
        this.minimum = minimum;
    }

    public Boolean getExclusiveMinimum() {
        return exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxItems() {
        return maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMinItems() {
        return minItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    public Boolean getUniqueItems() {
        return uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public Number getMultipleOf() {
        return multipleOf;
    }

    public void setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
    }

    public boolean hasStringValidation() {
        return null != pattern || null != maxLength || null != minLength || null != enums;
    }

    public boolean hasNumberValidation() {
        return null != maximum || null != minimum;
    }

    public boolean hasArrayValidation() {
        return null != minItems || null != maxItems;
    }

    public boolean hasEnumValidation() {
        return null != enums && enums.length > 0;
    }

    public boolean hasValidation() {
        if(isRequired()) {
            return true;
        }

        if(hasStringValidation() || hasNumberValidation() || hasArrayValidation() || hasEnumValidation()) {
            return true;
        }

        return false;
    }
}
