/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;
import leap.lang.json.JsonName;

import java.util.ArrayList;
import java.util.List;

public class MetaOptionSet extends MetaObjNamed {

    @JsonName("default")
    protected String defaults;

    @Required
    protected List<MetaOption> items = new ArrayList<>();

    public String getDefaults() {
        return defaults;
    }

    public void setDefaults(String defaults) {
        this.defaults = defaults;
    }

    public List<MetaOption> getItems() {
        return items;
    }

    public void setItems(List<MetaOption> items) {
        this.items = items;
    }

    public void add(MetaOption option) {
        items.add(option);
    }

}
