/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;
import leap.lang.json.JsonIgnore;
import leap.lang.meta.MType;

public class MetaParameterBase extends MetaObjValidated {

    /**
     * Swagger's data type.
     */
    @Required
    protected String type;

    /**
     * Swagger's format.
     */
    protected String format;

    @JsonIgnore
    protected boolean file;

    @JsonIgnore
    protected MType resolvedType;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isFile() {
        return file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public MType getResolvedType() {
        return resolvedType;
    }

    public void setResolvedType(MType resolvedType) {
        this.resolvedType = resolvedType;
    }
}
