/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.beans.BeanProperty;
import leap.lang.json.JsonIgnore;
import leap.web.api.meta.model.MApiPropertyBuilder;

public class MetaProperty extends MetaParameterBase {

    protected Boolean readOnly;

    @JsonIgnore
    protected BeanProperty mappingProperty;

    @JsonIgnore
    protected MApiPropertyBuilder apiProperty;

    public boolean isReadOnly() {
        return null != readOnly && readOnly;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public BeanProperty getMappingProperty() {
        return mappingProperty;
    }

    public void setMappingProperty(BeanProperty mappingProperty) {
        this.mappingProperty = mappingProperty;
    }

    public MApiPropertyBuilder getApiProperty() {
        return apiProperty;
    }

    public void setApiProperty(MApiPropertyBuilder apiProperty) {
        this.apiProperty = apiProperty;
    }
}