/*
 *  Copyright 2018 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package jmms.core.model;

import leap.lang.convert.StringParsable;
import leap.lang.expression.Expression;
import leap.lang.json.JsonIgnore;

public class MetaQueryFilter extends MetaObjNamed implements StringParsable {

    protected String cond;
    protected String where;

    @JsonIgnore
    protected Expression condExpr;

    @JsonIgnore
    protected Expression whereExpr;

    public String getCond() {
        return cond;
    }

    public void setCond(String cond) {
        this.cond = cond;
    }

    public String getWhere() {
        return where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public Expression getCondExpr() {
        return condExpr;
    }

    public void setCondExpr(Expression condExpr) {
        this.condExpr = condExpr;
    }

    public Expression getWhereExpr() {
        return whereExpr;
    }

    public void setWhereExpr(Expression whereExpr) {
        this.whereExpr = whereExpr;
    }

    @Override
    public void parseString(String s) {
        if(null != s) {
            int index = s.indexOf("->");
            if(index < 0) {
                this.where = s.trim();
            }else {
                this.cond = s.substring(0,index).trim();
                this.where = s.substring(index+2).trim();
            }
        }
    }
}