/*
 *  Copyright 2018 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package jmms.core.model;

import leap.lang.collection.WrappedCaseInsensitiveMap;
import leap.lang.json.JsonIgnore;

import java.util.Map;

public class MetaQueryFilterSet extends MetaObjNamed {

    /**
     * The query filters.
     */
    protected Map<String, MetaQueryFilter> filters = new WrappedCaseInsensitiveMap<>();

    /**
     * The default query filter.
     */
    @JsonIgnore
    protected MetaQueryFilter defaultFilter;

    public Map<String, MetaQueryFilter> getFilters() {
        return filters;
    }

    public void setFilters(Map<String, MetaQueryFilter> filters) {
        this.filters = WrappedCaseInsensitiveMap.create(filters);
    }

    public void addFilter(MetaQueryFilter filter) {
        this.filters.put(filter.getName(), filter);
    }

    public MetaQueryFilter getDefaultFilter() {
        return defaultFilter;
    }

    public void setDefaultFilter(MetaQueryFilter defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

}