/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;

import java.util.LinkedHashMap;
import java.util.Map;

public class MetaTestAction extends MetaObjTitled {

    /**
     * The type of step.
     */
    @Required
    protected String type;

    /**
     * The execution of step, according to the type.
     */
    @Required
    protected String exec;

    /**
     * The parameters of execution, according to the type.
     */
    protected Map<String, Object> params = new LinkedHashMap<>();

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExec() {
        return exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public <T> T getParam(String name) {
        return (T)params.get(name);
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setParam(String name, Object value) {
        params.put(name, value);
    }

    public void setParam(String prefix, String name, Object value) {
        Map nested = (Map)params.get(prefix);
        if(null == nested) {
            nested = new LinkedHashMap();
            params.put(prefix, nested);
        }
        nested.put(name, value);
    }
}
