/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.core.validation.annotations.Required;
import leap.lang.annotation.Order;
import leap.lang.util.ShortUUID;

import java.util.ArrayList;
import java.util.List;

public class MetaTestCase extends MetaObjNamed {

    /**
     * The id of test case.
     */
    @Required @Order(1)
    protected String id = ShortUUID.randomUUID();

    /**
     * The type of test case.
     */
    @Required
    protected String type = "default";

    /**
     * The resolved steps of test case. Optional.
     */
    protected List<MetaTestStep> steps = new ArrayList<>();

    /**
     * Is a generated test case ?
     */
    protected Boolean generated;

    /**
     * Is a crud test case ?.
     */
    protected Boolean crud;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<MetaTestStep> getSteps() {
        return steps;
    }

    public void addStep(MetaTestStep step) {
        steps.add(step);
    }

    public void setSteps(List<MetaTestStep> steps) {
        this.steps = steps;
    }

    public boolean isGenerated() {
        return null != generated && generated;
    }

    public Boolean getGenerated() {
        return generated;
    }

    public void setGenerated(Boolean generated) {
        this.generated = generated;
    }

    public boolean isCrud() {
        return null != crud && crud;
    }

    public Boolean getCrud() {
        return crud;
    }

    public void setCrud(Boolean crud) {
        this.crud = crud;
    }
}