/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.model;

import leap.lang.Strings;

import java.util.ArrayList;
import java.util.List;

public class MetaTestStep extends MetaTestAction {

    /**
     * The assertions of action result.
     */
    protected List<MetaTestAssertion> asserts = new ArrayList<>();

    public List<MetaTestAssertion> getAsserts() {
        return asserts;
    }

    public void setAsserts(List<MetaTestAssertion> asserts) {
        this.asserts = asserts;
    }

    public void addAssert(MetaTestAssertion assertion) {
        asserts.add(assertion);
    }

    public String getTitleOrExec() {
        return Strings.isEmpty(title) ? exec : title;
    }
}