/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.parser;

abstract class AbstractLineParser {

    protected static int indexOfWhiteSpaceOrEnd(String s) {
        int i = 0;
        for(;;) {
            if(i == s.length()) {
                break;
            }

            if(Character.isWhitespace(s.charAt(i))) {
                break;
            }

            i++;
        }
        return i;
    }

    protected static boolean startsWithSkipWhiteSpace(String s, String prefix) {
        for(int i=0;i<s.length();i++) {
            char ch = s.charAt(i);
            if(Character.isWhitespace(ch)) {
                continue;
            }
            return s.startsWith(prefix, i);
        }
        return false;
    }

    protected static String content(String line) {
        String content = line.trim();
        if(content.startsWith("*")) {
            content = content.substring(1).trim();
        }
        return content;
    }

}
