/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.parser;

import jmms.core.model.MetaTestAssertion;
import leap.lang.Strings;

public class AssertDefParser {

    public static void parse(MetaTestAssertion assertion, String s) {
        s = s .trim();
        if(!Strings.isEmpty(s)) {
            //expr //title

            int index = s.indexOf("//");
            if(index > 0) {
                assertion.setExpr(s.substring(0, index).trim());
                assertion.setTitle(s.substring(index + 2).trim());
            }else {
                assertion.setExpr(s);
            }
        }
    }
}
