/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.parser;

import leap.lang.Strings;

public class OpsParser {

    public static Ops parse(String s) throws IllegalArgumentException {
        s = Strings.trim(s);
        if(Strings.isEmpty(s)) {
            return null;
        }

        //Disable all firstly.
        Ops ops = new Ops();
        ops.setAll(false);
        if(s.equalsIgnoreCase("none")) {
            return ops;
        }

        if(s.equals("*") || s.equalsIgnoreCase("all")) {
            ops.setCrud(true);
            return ops;
        }

        if(s.equals("*+") || s.equalsIgnoreCase("all+")) {
            ops.setAll(true);
            return ops;
        }

        s = Strings.replace(s, ',', ' ');
        String[] parts = Strings.splitWhitespaces(s);
        for(String part : parts) {

            if(part.equalsIgnoreCase("read")) {
                ops.setFind(true);
                ops.setQuery(true);
                continue;
            }

            if(part.equalsIgnoreCase("write")) {
                ops.setCreate(true);
                ops.setUpdate(true);
                continue;
            }

            if(part.equalsIgnoreCase("create")) {
                ops.setCreate(true);
                continue;
            }

            if(part.equalsIgnoreCase("update")) {
                ops.setUpdate(true);
                continue;
            }

            if(part.equalsIgnoreCase("delete")) {
                ops.setDelete(true);
                continue;
            }

            if(part.equalsIgnoreCase("find")) {
                ops.setFind(true);
                continue;
            }

            if(part.equalsIgnoreCase("query")) {
                ops.setQuery(true);
                continue;
            }

            if(part.equalsIgnoreCase("count")) {
                ops.setCount(true);
                continue;
            }

            if(part.equalsIgnoreCase("calc")) {
                ops.setCalc(true);
            }

            throw new IllegalArgumentException("Invalid operation '" + part + "'");
        }

        return ops;
    }

    public static final class Ops {
        private Boolean create;
        private Boolean update;
        private Boolean delete;
        private Boolean find;
        private Boolean query;
        private Boolean count;
        private Boolean calc;

        public Boolean getCreate() {
            return create;
        }

        public void setCreate(Boolean create) {
            this.create = create;
        }

        public Boolean getUpdate() {
            return update;
        }

        public void setUpdate(Boolean update) {
            this.update = update;
        }

        public Boolean getDelete() {
            return delete;
        }

        public void setDelete(Boolean delete) {
            this.delete = delete;
        }

        public Boolean getFind() {
            return find;
        }

        public void setFind(Boolean find) {
            this.find = find;
        }

        public Boolean getQuery() {
            return query;
        }

        public void setQuery(Boolean query) {
            this.query = query;
        }

        public Boolean getCount() {
            return count;
        }

        public void setCount(Boolean count) {
            this.count = count;
        }

        public Boolean getCalc() {
            return calc;
        }

        public void setCalc(Boolean calc) {
            this.calc = calc;
        }

        public void setCrud(boolean enable) {
            this.create = enable;
            this.update = enable;
            this.delete = enable;
            this.find   = enable;
            this.query  = enable;
        }

        public void setAll(boolean enable) {
            this.create = enable;
            this.update = enable;
            this.delete = enable;
            this.find   = enable;
            this.query  = enable;
            this.count  = enable;
            this.calc   = enable;
        }
    }

    protected OpsParser() {


    }

}
