/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.validate;

import jmms.core.model.MetaApi;
import jmms.core.model.MetaEntity;
import jmms.core.model.MetaField;
import jmms.core.model.MetaModelBase;
import leap.core.validation.Validation;
import leap.lang.Arrays2;
import leap.lang.Beans;
import leap.lang.Out;
import leap.lang.Strings;
import leap.web.api.meta.model.MApiPropertyBuilder;

import java.util.*;

public class EntityValidator extends ModelValidatorBase<MetaEntity> {

    public EntityValidator(String name, boolean required, MetaApi api, MetaEntity entity, boolean partial) {
        super(name, required, api, entity, partial);
    }

    @Override
    protected PropertyValidation[] resolvePropertyValidations(MetaApi api, MetaEntity model, String name) {
        List<PropertyValidation> list = new ArrayList<>();

        for(MetaField field : model.getFields().values()) {
            MApiPropertyBuilder ap = field.getApiProperty();
            if(null == ap || ap.isReadOnly()) {
                continue;
            }

            String qname = qname(name, field.getName());

            Validator validator = Validators.of(api, qname, ap.isRequired(), ap.getType(), field);
            if(null != validator) {
                list.add(new PropertyValidation(ap.getName(), validator));
            }
        }

        return list.toArray(new PropertyValidation[0]);
    }

}