/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.validate;

import leap.core.validation.Validation;
import leap.lang.Out;
import leap.lang.annotation.Nullable;

import java.util.HashMap;
import java.util.Map;

public class MapValidator extends Validator {

    protected final Validator valueValidator;

    public MapValidator(String name, boolean required, @Nullable Validator valueValidator) {
        super(name, required);

        this.valueValidator = valueValidator;
    }

    @Override
    protected boolean doValidate(Validation validation, String name, Object value, Out<Object> out) {
        if(!(value instanceof Map)) {
            validation.addError(name, "Invalid value, must be a map");
            return false;
        }

        if(null != valueValidator) {
            Map map = (Map)value;

            Map converted = null;
            Out<Object> entryOut = new Out<>();
            for(Object object : map.entrySet()) {
                Map.Entry entry = (Map.Entry)object;

                if(!valueValidator.validate(validation, qname(name, entry.getKey().toString()), entry.getValue(), entryOut)) {
                    return false;
                }

                if(entryOut.isPresent()) {
                    if(null == converted) {
                        converted = new HashMap();
                    }
                    converted.put(entry.getKey(), entryOut.getAndReset());
                }
            }

            if(null != converted) {
                map.putAll(converted);
            }
        }

        return true;
    }

}