/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.core.validate;

import leap.core.validation.Validation;
import leap.lang.Objects2;
import leap.lang.Out;
import leap.lang.Strings;
import leap.web.action.Argument;
import leap.web.action.ArgumentValidator;

public abstract class Validator implements ArgumentValidator{

    private final String  name;
    private final boolean required;

    protected Validator(String name, boolean required) {
        this.name     = name;
        this.required = required;
    }

    @Override
    public final boolean validate(Validation validation, Argument arg, Object value, Out<Object> out) {
        return validate(validation, value, out);
    }

    public final boolean validate(Validation validation, Object value, Out<Object> out) {
        return this.validate(validation, name, value, out);
    }

    public final boolean validate(Validation validation, String name, Object value, Out<Object> out) {
        if(required && !validateRequired(validation, name, value)) {
            return false;
        }

        if(null == value) {
            return true;
        }

        return doValidate(validation, name, value, out);
    }

    protected boolean validateRequired(Validation validation, String name, Object value) {
        return validation.stateRequired(name, value);
    }

    protected abstract boolean doValidate(Validation validation, String name, Object value, Out<Object> out);

    protected static final String qname(String name, String subName) {
        return Strings.isEmpty(name) ? subName : name + "." + subName;
    }
}